@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.DataRepositoryAssociationArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.DataRepositoryAssociationS3Args
import com.pulumi.aws.fsx.kotlin.inputs.DataRepositoryAssociationS3ArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a FSx for Lustre Data Repository Association. See [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html) for more information.
 * > **NOTE:** Data Repository Associations are only compatible with AWS FSx for Lustre File Systems and `PERSISTENT_2` deployment type.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.fsx.LustreFileSystem;
 * import com.pulumi.aws.fsx.LustreFileSystemArgs;
 * import com.pulumi.aws.fsx.DataRepositoryAssociation;
 * import com.pulumi.aws.fsx.DataRepositoryAssociationArgs;
 * import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3Args;
 * import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3AutoExportPolicyArgs;
 * import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3AutoImportPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var exampleLustreFileSystem = new LustreFileSystem("exampleLustreFileSystem", LustreFileSystemArgs.builder()
 *             .storageCapacity(1200)
 *             .subnetIds(aws_subnet.example().id())
 *             .deploymentType("PERSISTENT_2")
 *             .perUnitStorageThroughput(125)
 *             .build());
 *         var exampleDataRepositoryAssociation = new DataRepositoryAssociation("exampleDataRepositoryAssociation", DataRepositoryAssociationArgs.builder()
 *             .fileSystemId(exampleLustreFileSystem.id())
 *             .dataRepositoryPath(exampleBucketV2.id().applyValue(id -> String.format("s3://%s", id)))
 *             .fileSystemPath("/my-bucket")
 *             .s3(DataRepositoryAssociationS3Args.builder()
 *                 .autoExportPolicy(DataRepositoryAssociationS3AutoExportPolicyArgs.builder()
 *                     .events(
 *                         "NEW",
 *                         "CHANGED",
 *                         "DELETED")
 *                     .build())
 *                 .autoImportPolicy(DataRepositoryAssociationS3AutoImportPolicyArgs.builder()
 *                     .events(
 *                         "NEW",
 *                         "CHANGED",
 *                         "DELETED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import FSx Data Repository Associations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:fsx/dataRepositoryAssociation:DataRepositoryAssociation example dra-0b1cfaeca11088b10
 * ```
 * @property batchImportMetaDataOnCreate Set to true to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Defaults to `false`.
 * @property dataRepositoryPath The path to the Amazon S3 data repository that will be linked to the file system. The path must be an S3 bucket s3://myBucket/myPrefix/. This path specifies where in the S3 data repository files will be imported from or exported to. The same S3 bucket cannot be linked more than once to the same file system.
 * @property deleteDataInFilesystem Set to true to delete files from the file system upon deleting this data repository association. Defaults to `false`.
 * @property fileSystemId The ID of the Amazon FSx file system to on which to create a data repository association.
 * @property fileSystemPath A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `data_repository_path`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`. This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
 * @property importedFileChunkSize For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
 * @property s3 See the `s3` configuration block. Max of 1.
 * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
 * @property tags A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DataRepositoryAssociationArgs(
    public val batchImportMetaDataOnCreate: Output<Boolean>? = null,
    public val dataRepositoryPath: Output<String>? = null,
    public val deleteDataInFilesystem: Output<Boolean>? = null,
    public val fileSystemId: Output<String>? = null,
    public val fileSystemPath: Output<String>? = null,
    public val importedFileChunkSize: Output<Int>? = null,
    public val s3: Output<DataRepositoryAssociationS3Args>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.DataRepositoryAssociationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.DataRepositoryAssociationArgs =
        com.pulumi.aws.fsx.DataRepositoryAssociationArgs.builder()
            .batchImportMetaDataOnCreate(batchImportMetaDataOnCreate?.applyValue({ args0 -> args0 }))
            .dataRepositoryPath(dataRepositoryPath?.applyValue({ args0 -> args0 }))
            .deleteDataInFilesystem(deleteDataInFilesystem?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .fileSystemPath(fileSystemPath?.applyValue({ args0 -> args0 }))
            .importedFileChunkSize(importedFileChunkSize?.applyValue({ args0 -> args0 }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataRepositoryAssociationArgs].
 */
@PulumiTagMarker
public class DataRepositoryAssociationArgsBuilder internal constructor() {
    private var batchImportMetaDataOnCreate: Output<Boolean>? = null

    private var dataRepositoryPath: Output<String>? = null

    private var deleteDataInFilesystem: Output<Boolean>? = null

    private var fileSystemId: Output<String>? = null

    private var fileSystemPath: Output<String>? = null

    private var importedFileChunkSize: Output<Int>? = null

    private var s3: Output<DataRepositoryAssociationS3Args>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Set to true to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Defaults to `false`.
     */
    @JvmName("bqhkxawdjnkkwvqm")
    public suspend fun batchImportMetaDataOnCreate(`value`: Output<Boolean>) {
        this.batchImportMetaDataOnCreate = value
    }

    /**
     * @param value The path to the Amazon S3 data repository that will be linked to the file system. The path must be an S3 bucket s3://myBucket/myPrefix/. This path specifies where in the S3 data repository files will be imported from or exported to. The same S3 bucket cannot be linked more than once to the same file system.
     */
    @JvmName("uquwkcdalbnkwkag")
    public suspend fun dataRepositoryPath(`value`: Output<String>) {
        this.dataRepositoryPath = value
    }

    /**
     * @param value Set to true to delete files from the file system upon deleting this data repository association. Defaults to `false`.
     */
    @JvmName("parvtasrwvhrhusy")
    public suspend fun deleteDataInFilesystem(`value`: Output<Boolean>) {
        this.deleteDataInFilesystem = value
    }

    /**
     * @param value The ID of the Amazon FSx file system to on which to create a data repository association.
     */
    @JvmName("qjwcglnbnoxkarpo")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `data_repository_path`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`. This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     */
    @JvmName("kknvkwnrqlsahgbo")
    public suspend fun fileSystemPath(`value`: Output<String>) {
        this.fileSystemPath = value
    }

    /**
     * @param value For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     */
    @JvmName("ggghkbbupresxowt")
    public suspend fun importedFileChunkSize(`value`: Output<Int>) {
        this.importedFileChunkSize = value
    }

    /**
     * @param value See the `s3` configuration block. Max of 1.
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     */
    @JvmName("ksmihlvuvepkpixo")
    public suspend fun s3(`value`: Output<DataRepositoryAssociationS3Args>) {
        this.s3 = value
    }

    /**
     * @param value A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("atgwgheuuqjtxfuc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Set to true to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Defaults to `false`.
     */
    @JvmName("cfonlpnqjsfegidv")
    public suspend fun batchImportMetaDataOnCreate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchImportMetaDataOnCreate = mapped
    }

    /**
     * @param value The path to the Amazon S3 data repository that will be linked to the file system. The path must be an S3 bucket s3://myBucket/myPrefix/. This path specifies where in the S3 data repository files will be imported from or exported to. The same S3 bucket cannot be linked more than once to the same file system.
     */
    @JvmName("opgidmipapdhmcmn")
    public suspend fun dataRepositoryPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRepositoryPath = mapped
    }

    /**
     * @param value Set to true to delete files from the file system upon deleting this data repository association. Defaults to `false`.
     */
    @JvmName("sulpyfxuuidgktvl")
    public suspend fun deleteDataInFilesystem(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteDataInFilesystem = mapped
    }

    /**
     * @param value The ID of the Amazon FSx file system to on which to create a data repository association.
     */
    @JvmName("ktvegyrnwodxjhwn")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `data_repository_path`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`. This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     */
    @JvmName("ekkihdhqxinhkheg")
    public suspend fun fileSystemPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemPath = mapped
    }

    /**
     * @param value For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     */
    @JvmName("bohsmfdtdoogevwy")
    public suspend fun importedFileChunkSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importedFileChunkSize = mapped
    }

    /**
     * @param value See the `s3` configuration block. Max of 1.
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     */
    @JvmName("wfmjrgkjvwmmtktd")
    public suspend fun s3(`value`: DataRepositoryAssociationS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument See the `s3` configuration block. Max of 1.
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     */
    @JvmName("iyubjhoxylpjfuvw")
    public suspend fun s3(argument: suspend DataRepositoryAssociationS3ArgsBuilder.() -> Unit) {
        val toBeMapped = DataRepositoryAssociationS3ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    /**
     * @param value A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wromejvkdulqmxes")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lorrysakxxrqyvru")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataRepositoryAssociationArgs = DataRepositoryAssociationArgs(
        batchImportMetaDataOnCreate = batchImportMetaDataOnCreate,
        dataRepositoryPath = dataRepositoryPath,
        deleteDataInFilesystem = deleteDataInFilesystem,
        fileSystemId = fileSystemId,
        fileSystemPath = fileSystemPath,
        importedFileChunkSize = importedFileChunkSize,
        s3 = s3,
        tags = tags,
    )
}
