@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.FileCacheArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.FileCacheDataRepositoryAssociationArgs
import com.pulumi.aws.fsx.kotlin.inputs.FileCacheDataRepositoryAssociationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.FileCacheLustreConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.FileCacheLustreConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an Amazon File Cache cache.
 * See the [Create File Cache](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileCache.html) for more information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.FileCache;
 * import com.pulumi.aws.fsx.FileCacheArgs;
 * import com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationArgs;
 * import com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FileCache("example", FileCacheArgs.builder()
 *             .dataRepositoryAssociations(FileCacheDataRepositoryAssociationArgs.builder()
 *                 .dataRepositoryPath("nfs://filer.domain.com")
 *                 .dataRepositorySubdirectories(
 *                     "test",
 *                     "test2")
 *                 .fileCachePath("/ns1")
 *                 .nfs(FileCacheDataRepositoryAssociationNfArgs.builder()
 *                     .dnsIps(
 *                         "192.168.0.1",
 *                         "192.168.0.2")
 *                     .version("NFS3")
 *                     .build())
 *                 .build())
 *             .fileCacheType("LUSTRE")
 *             .fileCacheTypeVersion("2.12")
 *             .lustreConfigurations(FileCacheLustreConfigurationArgs.builder()
 *                 .deploymentType("CACHE_1")
 *                 .metadataConfigurations(FileCacheLustreConfigurationMetadataConfigurationArgs.builder()
 *                     .storageCapacity(2400)
 *                     .build())
 *                 .perUnitStorageThroughput(1000)
 *                 .weeklyMaintenanceStartTime("2:05:00")
 *                 .build())
 *             .subnetIds(aws_subnet.test1().id())
 *             .storageCapacity(1200)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon File Cache cache using the resource `id`. For example:
 * ```sh
 *  $ pulumi import aws:fsx/fileCache:FileCache example fc-8012925589
 * ```
 * @property copyTagsToDataRepositoryAssociations A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
 * @property dataRepositoryAssociations See the `data_repository_association` configuration block. Max of 8.
 * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
 * @property fileCacheType The type of cache that you're creating. The only supported value is `LUSTRE`.
 * @property fileCacheTypeVersion The version for the type of cache that you're creating. The only supported value is `2.12`.
 * @property kmsKeyId Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
 * @property lustreConfigurations See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
 * @property securityGroupIds A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
 * @property storageCapacity The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
 * @property subnetIds A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FileCacheArgs(
    public val copyTagsToDataRepositoryAssociations: Output<Boolean>? = null,
    public val dataRepositoryAssociations: Output<List<FileCacheDataRepositoryAssociationArgs>>? =
        null,
    public val fileCacheType: Output<String>? = null,
    public val fileCacheTypeVersion: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val lustreConfigurations: Output<List<FileCacheLustreConfigurationArgs>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val storageCapacity: Output<Int>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.FileCacheArgs> {
    override fun toJava(): com.pulumi.aws.fsx.FileCacheArgs =
        com.pulumi.aws.fsx.FileCacheArgs.builder()
            .copyTagsToDataRepositoryAssociations(
                copyTagsToDataRepositoryAssociations?.applyValue({ args0 ->
                    args0
                }),
            )
            .dataRepositoryAssociations(
                dataRepositoryAssociations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .fileCacheType(fileCacheType?.applyValue({ args0 -> args0 }))
            .fileCacheTypeVersion(fileCacheTypeVersion?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .lustreConfigurations(
                lustreConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageCapacity(storageCapacity?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FileCacheArgs].
 */
@PulumiTagMarker
public class FileCacheArgsBuilder internal constructor() {
    private var copyTagsToDataRepositoryAssociations: Output<Boolean>? = null

    private var dataRepositoryAssociations: Output<List<FileCacheDataRepositoryAssociationArgs>>? =
        null

    private var fileCacheType: Output<String>? = null

    private var fileCacheTypeVersion: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var lustreConfigurations: Output<List<FileCacheLustreConfigurationArgs>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var storageCapacity: Output<Int>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
     */
    @JvmName("thqitpwcfctmdglc")
    public suspend fun copyTagsToDataRepositoryAssociations(`value`: Output<Boolean>) {
        this.copyTagsToDataRepositoryAssociations = value
    }

    /**
     * @param value See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("cikqdephehpyyoft")
    public suspend
    fun dataRepositoryAssociations(`value`: Output<List<FileCacheDataRepositoryAssociationArgs>>) {
        this.dataRepositoryAssociations = value
    }

    @JvmName("tfqdjeuuawubngfv")
    public suspend fun dataRepositoryAssociations(
        vararg
        values: Output<FileCacheDataRepositoryAssociationArgs>,
    ) {
        this.dataRepositoryAssociations = Output.all(values.asList())
    }

    /**
     * @param values See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("lhnvqehjotwqemvm")
    public suspend
    fun dataRepositoryAssociations(values: List<Output<FileCacheDataRepositoryAssociationArgs>>) {
        this.dataRepositoryAssociations = Output.all(values)
    }

    /**
     * @param value The type of cache that you're creating. The only supported value is `LUSTRE`.
     */
    @JvmName("nlpxbhosafafshwg")
    public suspend fun fileCacheType(`value`: Output<String>) {
        this.fileCacheType = value
    }

    /**
     * @param value The version for the type of cache that you're creating. The only supported value is `2.12`.
     */
    @JvmName("bgixdshhxnmttuhs")
    public suspend fun fileCacheTypeVersion(`value`: Output<String>) {
        this.fileCacheTypeVersion = value
    }

    /**
     * @param value Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
     */
    @JvmName("yslypywqhrctuciu")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("vgcanawmlbvkjnhj")
    public suspend fun lustreConfigurations(`value`: Output<List<FileCacheLustreConfigurationArgs>>) {
        this.lustreConfigurations = value
    }

    @JvmName("ynqbrakqlvgmonoi")
    public suspend fun lustreConfigurations(vararg values: Output<FileCacheLustreConfigurationArgs>) {
        this.lustreConfigurations = Output.all(values.asList())
    }

    /**
     * @param values See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("ybtgtfslxgtwcyxr")
    public suspend fun lustreConfigurations(values: List<Output<FileCacheLustreConfigurationArgs>>) {
        this.lustreConfigurations = Output.all(values)
    }

    /**
     * @param value A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    @JvmName("ohnryohrjlkweiqe")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("edgcupyebssvnikw")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    @JvmName("mvgdptxvbiobaqif")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
     */
    @JvmName("lwprmbflxdokpbrm")
    public suspend fun storageCapacity(`value`: Output<Int>) {
        this.storageCapacity = value
    }

    /**
     * @param value A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    @JvmName("pswwnbfymeqgwosd")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("bbboojlaruytktfr")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    @JvmName("qkdmrkoqdjevwqkt")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("heyfrxutwlcwlquc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
     */
    @JvmName("uqethoombpfdmvho")
    public suspend fun copyTagsToDataRepositoryAssociations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToDataRepositoryAssociations = mapped
    }

    /**
     * @param value See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("mqjlajqgtkcaownl")
    public suspend
    fun dataRepositoryAssociations(`value`: List<FileCacheDataRepositoryAssociationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param argument See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("uiudnlgrsnlmvgri")
    public suspend
    fun dataRepositoryAssociations(argument: List<suspend FileCacheDataRepositoryAssociationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileCacheDataRepositoryAssociationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param argument See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("trocpulahtmqmipm")
    public suspend fun dataRepositoryAssociations(
        vararg
        argument: suspend FileCacheDataRepositoryAssociationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FileCacheDataRepositoryAssociationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param argument See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("tdtxnwjljcsvckbq")
    public suspend
    fun dataRepositoryAssociations(argument: suspend FileCacheDataRepositoryAssociationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FileCacheDataRepositoryAssociationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param values See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("orcxrlyymksliyfw")
    public suspend fun dataRepositoryAssociations(
        vararg
        values: FileCacheDataRepositoryAssociationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param value The type of cache that you're creating. The only supported value is `LUSTRE`.
     */
    @JvmName("nvnlxgqhhblshrbi")
    public suspend fun fileCacheType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileCacheType = mapped
    }

    /**
     * @param value The version for the type of cache that you're creating. The only supported value is `2.12`.
     */
    @JvmName("ijcpcuvsqxgvdmof")
    public suspend fun fileCacheTypeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileCacheTypeVersion = mapped
    }

    /**
     * @param value Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
     */
    @JvmName("scemfwsgfjqaqwab")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("qqjsvsoarlstpotv")
    public suspend fun lustreConfigurations(`value`: List<FileCacheLustreConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lustreConfigurations = mapped
    }

    /**
     * @param argument See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("nxvgsapcfyyypbdv")
    public suspend
    fun lustreConfigurations(argument: List<suspend FileCacheLustreConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileCacheLustreConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lustreConfigurations = mapped
    }

    /**
     * @param argument See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("mrxsaloilaquiffr")
    public suspend fun lustreConfigurations(
        vararg
        argument: suspend FileCacheLustreConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FileCacheLustreConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lustreConfigurations = mapped
    }

    /**
     * @param argument See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("tswmxpaqafgmnxkl")
    public suspend
    fun lustreConfigurations(argument: suspend FileCacheLustreConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FileCacheLustreConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lustreConfigurations = mapped
    }

    /**
     * @param values See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("rgyjklfnfudgnsvf")
    public suspend fun lustreConfigurations(vararg values: FileCacheLustreConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lustreConfigurations = mapped
    }

    /**
     * @param value A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    @JvmName("nhcoutdaaysgtcku")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    @JvmName("bthpaqelvrnbvsge")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
     */
    @JvmName("nrximngusoyuepql")
    public suspend fun storageCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacity = mapped
    }

    /**
     * @param value A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    @JvmName("fslcgviwttkicoyd")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    @JvmName("ltftymxaikwclobh")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qeuuhskbhcesaijb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("edbvuochjhajsjwh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FileCacheArgs = FileCacheArgs(
        copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations,
        dataRepositoryAssociations = dataRepositoryAssociations,
        fileCacheType = fileCacheType,
        fileCacheTypeVersion = fileCacheTypeVersion,
        kmsKeyId = kmsKeyId,
        lustreConfigurations = lustreConfigurations,
        securityGroupIds = securityGroupIds,
        storageCapacity = storageCapacity,
        subnetIds = subnetIds,
        tags = tags,
    )
}
