@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.FsxFunctions.getOntapFileSystemPlain
import com.pulumi.aws.fsx.FsxFunctions.getOntapStorageVirtualMachinePlain
import com.pulumi.aws.fsx.FsxFunctions.getOntapStorageVirtualMachinesPlain
import com.pulumi.aws.fsx.FsxFunctions.getOpenZfsSnapshotPlain
import com.pulumi.aws.fsx.FsxFunctions.getWindowsFileSystemPlain
import com.pulumi.aws.fsx.kotlin.inputs.GetOntapFileSystemPlainArgs
import com.pulumi.aws.fsx.kotlin.inputs.GetOntapFileSystemPlainArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.GetOntapStorageVirtualMachineFilter
import com.pulumi.aws.fsx.kotlin.inputs.GetOntapStorageVirtualMachinePlainArgs
import com.pulumi.aws.fsx.kotlin.inputs.GetOntapStorageVirtualMachinePlainArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.GetOntapStorageVirtualMachinesFilter
import com.pulumi.aws.fsx.kotlin.inputs.GetOntapStorageVirtualMachinesPlainArgs
import com.pulumi.aws.fsx.kotlin.inputs.GetOntapStorageVirtualMachinesPlainArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.GetOpenZfsSnapshotFilter
import com.pulumi.aws.fsx.kotlin.inputs.GetOpenZfsSnapshotPlainArgs
import com.pulumi.aws.fsx.kotlin.inputs.GetOpenZfsSnapshotPlainArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.GetWindowsFileSystemPlainArgs
import com.pulumi.aws.fsx.kotlin.inputs.GetWindowsFileSystemPlainArgsBuilder
import com.pulumi.aws.fsx.kotlin.outputs.GetOntapFileSystemResult
import com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineResult
import com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachinesResult
import com.pulumi.aws.fsx.kotlin.outputs.GetOpenZfsSnapshotResult
import com.pulumi.aws.fsx.kotlin.outputs.GetWindowsFileSystemResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fsx.kotlin.outputs.GetOntapFileSystemResult.Companion.toKotlin as getOntapFileSystemResultToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineResult.Companion.toKotlin as getOntapStorageVirtualMachineResultToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachinesResult.Companion.toKotlin as getOntapStorageVirtualMachinesResultToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.GetOpenZfsSnapshotResult.Companion.toKotlin as getOpenZfsSnapshotResultToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.GetWindowsFileSystemResult.Companion.toKotlin as getWindowsFileSystemResultToKotlin

public object FsxFunctions {
    /**
     * Retrieve information on FSx ONTAP File System.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.fsx.FsxFunctions;
     * import com.pulumi.aws.fsx.inputs.GetOntapFileSystemArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = FsxFunctions.getOntapFileSystem(GetOntapFileSystemArgs.builder()
     *             .id("fs-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOntapFileSystem.
     * @return A collection of values returned by getOntapFileSystem.
     */
    public suspend fun getOntapFileSystem(argument: GetOntapFileSystemPlainArgs):
        GetOntapFileSystemResult =
        getOntapFileSystemResultToKotlin(getOntapFileSystemPlain(argument.toJava()).await())

    /**
     * @see [getOntapFileSystem].
     * @param id Identifier of the file system (e.g. `fs-12345678`).
     * @param tags The tags associated with the file system.
     * @return A collection of values returned by getOntapFileSystem.
     */
    public suspend fun getOntapFileSystem(id: String, tags: Map<String, String>? = null):
        GetOntapFileSystemResult {
        val argument = GetOntapFileSystemPlainArgs(
            id = id,
            tags = tags,
        )
        return getOntapFileSystemResultToKotlin(getOntapFileSystemPlain(argument.toJava()).await())
    }

    /**
     * @see [getOntapFileSystem].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;fsx&#46;kotlin&#46;inputs&#46;GetOntapFileSystemPlainArgs].
     * @return A collection of values returned by getOntapFileSystem.
     */
    public suspend
    fun getOntapFileSystem(argument: suspend GetOntapFileSystemPlainArgsBuilder.() -> Unit):
        GetOntapFileSystemResult {
        val builder = GetOntapFileSystemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOntapFileSystemResultToKotlin(getOntapFileSystemPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information on FSx ONTAP Storage Virtual Machine (SVM).
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.fsx.FsxFunctions;
     * import com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = FsxFunctions.getOntapStorageVirtualMachine(GetOntapStorageVirtualMachineArgs.builder()
     *             .id("svm-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ### Filter Example
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.fsx.FsxFunctions;
     * import com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachineArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = FsxFunctions.getOntapStorageVirtualMachine(GetOntapStorageVirtualMachineArgs.builder()
     *             .filters(GetOntapStorageVirtualMachineFilterArgs.builder()
     *                 .name("file-system-id")
     *                 .values("fs-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOntapStorageVirtualMachine.
     * @return A collection of values returned by getOntapStorageVirtualMachine.
     */
    public suspend
    fun getOntapStorageVirtualMachine(argument: GetOntapStorageVirtualMachinePlainArgs):
        GetOntapStorageVirtualMachineResult =
        getOntapStorageVirtualMachineResultToKotlin(getOntapStorageVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getOntapStorageVirtualMachine].
     * @param filters Configuration block. Detailed below.
     * @param id Identifier of the storage virtual machine (e.g. `svm-12345678`).
     * @param tags
     * @return A collection of values returned by getOntapStorageVirtualMachine.
     */
    public suspend fun getOntapStorageVirtualMachine(
        filters: List<GetOntapStorageVirtualMachineFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetOntapStorageVirtualMachineResult {
        val argument = GetOntapStorageVirtualMachinePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getOntapStorageVirtualMachineResultToKotlin(getOntapStorageVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getOntapStorageVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;fsx&#46;kotlin&#46;inputs&#46;GetOntapStorageVirtualMachinePlainArgs].
     * @return A collection of values returned by getOntapStorageVirtualMachine.
     */
    public suspend
    fun getOntapStorageVirtualMachine(argument: suspend GetOntapStorageVirtualMachinePlainArgsBuilder.() -> Unit):
        GetOntapStorageVirtualMachineResult {
        val builder = GetOntapStorageVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOntapStorageVirtualMachineResultToKotlin(getOntapStorageVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a set of FSx ONTAP Storage Virtual Machine (SVM) IDs.
     * ## Example Usage
     * The following shows outputting all SVM IDs for a given FSx ONTAP File System.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.fsx.FsxFunctions;
     * import com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = FsxFunctions.getOntapStorageVirtualMachines(GetOntapStorageVirtualMachinesArgs.builder()
     *             .filters(GetOntapStorageVirtualMachinesFilterArgs.builder()
     *                 .name("file-system-id")
     *                 .values("fs-12345678")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOntapStorageVirtualMachines.
     * @return A collection of values returned by getOntapStorageVirtualMachines.
     */
    public suspend
    fun getOntapStorageVirtualMachines(argument: GetOntapStorageVirtualMachinesPlainArgs):
        GetOntapStorageVirtualMachinesResult =
        getOntapStorageVirtualMachinesResultToKotlin(getOntapStorageVirtualMachinesPlain(argument.toJava()).await())

    /**
     * @see [getOntapStorageVirtualMachines].
     * @param filters Configuration block. Detailed below.
     * @return A collection of values returned by getOntapStorageVirtualMachines.
     */
    public suspend
    fun getOntapStorageVirtualMachines(
        filters: List<GetOntapStorageVirtualMachinesFilter>? =
            null,
    ): GetOntapStorageVirtualMachinesResult {
        val argument = GetOntapStorageVirtualMachinesPlainArgs(
            filters = filters,
        )
        return getOntapStorageVirtualMachinesResultToKotlin(getOntapStorageVirtualMachinesPlain(argument.toJava()).await())
    }

    /**
     * @see [getOntapStorageVirtualMachines].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;fsx&#46;kotlin&#46;inputs&#46;GetOntapStorageVirtualMachinesPlainArgs].
     * @return A collection of values returned by getOntapStorageVirtualMachines.
     */
    public suspend
    fun getOntapStorageVirtualMachines(argument: suspend GetOntapStorageVirtualMachinesPlainArgsBuilder.() -> Unit):
        GetOntapStorageVirtualMachinesResult {
        val builder = GetOntapStorageVirtualMachinesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOntapStorageVirtualMachinesResultToKotlin(getOntapStorageVirtualMachinesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an Amazon FSx for OpenZFS Snapshot for use when provisioning new Volumes.
     * ## Example Usage
     * ### Root volume Example
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.fsx.FsxFunctions;
     * import com.pulumi.aws.fsx.inputs.GetOpenZfsSnapshotArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = FsxFunctions.getOpenZfsSnapshot(GetOpenZfsSnapshotArgs.builder()
     *             .filters(GetOpenZfsSnapshotFilterArgs.builder()
     *                 .name("volume-id")
     *                 .values("fsvol-073a32b6098a73feb")
     *                 .build())
     *             .mostRecent(true)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getOpenZfsSnapshot.
     * @return A collection of values returned by getOpenZfsSnapshot.
     */
    public suspend fun getOpenZfsSnapshot(argument: GetOpenZfsSnapshotPlainArgs):
        GetOpenZfsSnapshotResult =
        getOpenZfsSnapshotResultToKotlin(getOpenZfsSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getOpenZfsSnapshot].
     * @param filters One or more name/value pairs to filter off of. The
     * supported names are file-system-id or volume-id.
     * @param mostRecent If more than one result is returned, use the most recent snapshot.
     * @param name Name of the snapshot.
     * @param snapshotIds Returns information on a specific snapshot_id.
     * @param tags List of Tag values, with a maximum of 50 elements.
     * @return A collection of values returned by getOpenZfsSnapshot.
     */
    public suspend fun getOpenZfsSnapshot(
        filters: List<GetOpenZfsSnapshotFilter>? = null,
        mostRecent: Boolean? = null,
        name: String? = null,
        snapshotIds: List<String>? = null,
        tags: Map<String, String>? = null,
    ): GetOpenZfsSnapshotResult {
        val argument = GetOpenZfsSnapshotPlainArgs(
            filters = filters,
            mostRecent = mostRecent,
            name = name,
            snapshotIds = snapshotIds,
            tags = tags,
        )
        return getOpenZfsSnapshotResultToKotlin(getOpenZfsSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getOpenZfsSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;fsx&#46;kotlin&#46;inputs&#46;GetOpenZfsSnapshotPlainArgs].
     * @return A collection of values returned by getOpenZfsSnapshot.
     */
    public suspend
    fun getOpenZfsSnapshot(argument: suspend GetOpenZfsSnapshotPlainArgsBuilder.() -> Unit):
        GetOpenZfsSnapshotResult {
        val builder = GetOpenZfsSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOpenZfsSnapshotResultToKotlin(getOpenZfsSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information on FSx Windows File System.
     * ## Example Usage
     * ### Root volume Example
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.fsx.FsxFunctions;
     * import com.pulumi.aws.fsx.inputs.GetWindowsFileSystemArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = FsxFunctions.getWindowsFileSystem(GetWindowsFileSystemArgs.builder()
     *             .id("fs-12345678")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getWindowsFileSystem.
     * @return A collection of values returned by getWindowsFileSystem.
     */
    public suspend fun getWindowsFileSystem(argument: GetWindowsFileSystemPlainArgs):
        GetWindowsFileSystemResult =
        getWindowsFileSystemResultToKotlin(getWindowsFileSystemPlain(argument.toJava()).await())

    /**
     * @see [getWindowsFileSystem].
     * @param id Identifier of the file system (e.g. `fs-12345678`).
     * @param tags The tags to associate with the file system.
     * @return A collection of values returned by getWindowsFileSystem.
     */
    public suspend fun getWindowsFileSystem(id: String, tags: Map<String, String>? = null):
        GetWindowsFileSystemResult {
        val argument = GetWindowsFileSystemPlainArgs(
            id = id,
            tags = tags,
        )
        return getWindowsFileSystemResultToKotlin(getWindowsFileSystemPlain(argument.toJava()).await())
    }

    /**
     * @see [getWindowsFileSystem].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;fsx&#46;kotlin&#46;inputs&#46;GetWindowsFileSystemPlainArgs].
     * @return A collection of values returned by getWindowsFileSystem.
     */
    public suspend
    fun getWindowsFileSystem(argument: suspend GetWindowsFileSystemPlainArgsBuilder.() -> Unit):
        GetWindowsFileSystemResult {
        val builder = GetWindowsFileSystemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWindowsFileSystemResultToKotlin(getWindowsFileSystemPlain(builtArgument.toJava()).await())
    }
}
