@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.LustreFileSystemArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.LustreFileSystemLogConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.LustreFileSystemLogConfigurationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.LustreFileSystemRootSquashConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.LustreFileSystemRootSquashConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a FSx Lustre File System. See the [FSx Lustre Guide](https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html) for more information.
 * > **NOTE:** `auto_import_policy`, `export_path`, `import_path` and `imported_file_chunk_size` are not supported with the `PERSISTENT_2` deployment type. Use `aws.fsx.DataRepositoryAssociation` instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.LustreFileSystem;
 * import com.pulumi.aws.fsx.LustreFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LustreFileSystem("example", LustreFileSystemArgs.builder()
 *             .importPath(String.format("s3://%s", aws_s3_bucket.example().bucket()))
 *             .storageCapacity(1200)
 *             .subnetIds(aws_subnet.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:fsx/lustreFileSystem:LustreFileSystem example fs-543ab12b1ca672f33
 * ```
 *  Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property autoImportPolicy How Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. see [Auto Import Data Repo](https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html) for more details. Only supported on `PERSISTENT_1` deployment types.
 * @property automaticBackupRetentionDays The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days. only valid for `PERSISTENT_1` and `PERSISTENT_2` deployment_type.
 * @property backupId The ID of the source backup to create the filesystem from.
 * @property copyTagsToBackups A boolean flag indicating whether tags for the file system should be copied to backups. Applicable for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. The default value is false.
 * @property dailyAutomaticBackupStartTime A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. only valid for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Requires `automatic_backup_retention_days` to be set.
 * @property dataCompressionType Sets the data compression configuration for the file system. Valid values are `LZ4` and `NONE`. Default value is `NONE`. Unsetting this value reverts the compression type back to `NONE`.
 * @property deploymentType The filesystem deployment type. One of: `SCRATCH_1`, `SCRATCH_2`, `PERSISTENT_1`, `PERSISTENT_2`.
 * @property driveCacheType The type of drive cache used by `PERSISTENT_1` filesystems that are provisioned with `HDD` storage_type. Required for `HDD` storage_type, set to either `READ` or `NONE`.
 * @property exportPath S3 URI (with optional prefix) where the root of your Amazon FSx file system is exported. Can only be specified with `import_path` argument and the path must use the same Amazon S3 bucket as specified in `import_path`. Set equal to `import_path` to overwrite files on export. Defaults to `s3://{IMPORT BUCKET}/FSxLustre{CREATION TIMESTAMP}`. Only supported on `PERSISTENT_1` deployment types.
 * @property fileSystemTypeVersion Sets the Lustre version for the file system that you're creating. Valid values are 2.10 for `SCRATCH_1`, `SCRATCH_2` and `PERSISTENT_1` deployment types. Valid values for 2.12 include all deployment types.
 * @property importPath S3 URI (with optional prefix) that you're using as the data repository for your FSx for Lustre file system. For example, `s3://example-bucket/optional-prefix/`. Only supported on `PERSISTENT_1` deployment types.
 * @property importedFileChunkSize For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. Can only be specified with `import_path` argument. Defaults to `1024`. Minimum of `1` and maximum of `512000`. Only supported on `PERSISTENT_1` deployment types.
 * @property kmsKeyId ARN for the KMS Key to encrypt the file system at rest, applicable for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Defaults to an AWS managed KMS Key.
 * @property logConfiguration The Lustre logging configuration used when creating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.
 * @property perUnitStorageThroughput Describes the amount of read and write throughput for each 1 tebibyte of storage, in MB/s/TiB, required for the `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Valid values for `PERSISTENT_1` deployment_type and `SSD` storage_type are 50, 100, 200. Valid values for `PERSISTENT_1` deployment_type and `HDD` storage_type are 12, 40. Valid values for `PERSISTENT_2` deployment_type and ` SSD` storage_type are 125, 250, 500, 1000.
 * @property rootSquashConfiguration The Lustre root squash configuration used when creating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
 * @property securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
 * @property storageCapacity The storage capacity (GiB) of the file system. Minimum of `1200`. See more details at [Allowed values for Fsx storage capacity](https://docs&#46;aws&#46;amazon&#46;com/fsx/latest/APIReference/API_CreateFileSystem&#46;html#FSx-CreateFileSystem-request-StorageCapacity)&#46; Update is allowed only for `SCRATCH_2`, `PERSISTENT_1` and `PERSISTENT_2` deployment types, See more details at [Fsx Storage Capacity Update](https://docs.aws.amazon.com/fsx/latest/APIReference/API_UpdateFileSystem.html#FSx-UpdateFileSystem-request-StorageCapacity). Required when not creating filesystem for a backup.
 * @property storageType The filesystem storage type. Either `SSD` or `HDD`, defaults to `SSD`. `HDD` is only supported on `PERSISTENT_1` deployment types.
 * @property subnetIds A list of IDs for the subnets that the file system will be accessible from. File systems currently support only one subnet. The file server is also launched in that subnet's Availability Zone.
 * @property tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
 */
public data class LustreFileSystemArgs(
    public val autoImportPolicy: Output<String>? = null,
    public val automaticBackupRetentionDays: Output<Int>? = null,
    public val backupId: Output<String>? = null,
    public val copyTagsToBackups: Output<Boolean>? = null,
    public val dailyAutomaticBackupStartTime: Output<String>? = null,
    public val dataCompressionType: Output<String>? = null,
    public val deploymentType: Output<String>? = null,
    public val driveCacheType: Output<String>? = null,
    public val exportPath: Output<String>? = null,
    public val fileSystemTypeVersion: Output<String>? = null,
    public val importPath: Output<String>? = null,
    public val importedFileChunkSize: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val logConfiguration: Output<LustreFileSystemLogConfigurationArgs>? = null,
    public val perUnitStorageThroughput: Output<Int>? = null,
    public val rootSquashConfiguration: Output<LustreFileSystemRootSquashConfigurationArgs>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val storageCapacity: Output<Int>? = null,
    public val storageType: Output<String>? = null,
    public val subnetIds: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val weeklyMaintenanceStartTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.LustreFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.fsx.LustreFileSystemArgs =
        com.pulumi.aws.fsx.LustreFileSystemArgs.builder()
            .autoImportPolicy(autoImportPolicy?.applyValue({ args0 -> args0 }))
            .automaticBackupRetentionDays(automaticBackupRetentionDays?.applyValue({ args0 -> args0 }))
            .backupId(backupId?.applyValue({ args0 -> args0 }))
            .copyTagsToBackups(copyTagsToBackups?.applyValue({ args0 -> args0 }))
            .dailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime?.applyValue({ args0 -> args0 }))
            .dataCompressionType(dataCompressionType?.applyValue({ args0 -> args0 }))
            .deploymentType(deploymentType?.applyValue({ args0 -> args0 }))
            .driveCacheType(driveCacheType?.applyValue({ args0 -> args0 }))
            .exportPath(exportPath?.applyValue({ args0 -> args0 }))
            .fileSystemTypeVersion(fileSystemTypeVersion?.applyValue({ args0 -> args0 }))
            .importPath(importPath?.applyValue({ args0 -> args0 }))
            .importedFileChunkSize(importedFileChunkSize?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .logConfiguration(logConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .perUnitStorageThroughput(perUnitStorageThroughput?.applyValue({ args0 -> args0 }))
            .rootSquashConfiguration(
                rootSquashConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageCapacity(storageCapacity?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .weeklyMaintenanceStartTime(weeklyMaintenanceStartTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LustreFileSystemArgs].
 */
@PulumiTagMarker
public class LustreFileSystemArgsBuilder internal constructor() {
    private var autoImportPolicy: Output<String>? = null

    private var automaticBackupRetentionDays: Output<Int>? = null

    private var backupId: Output<String>? = null

    private var copyTagsToBackups: Output<Boolean>? = null

    private var dailyAutomaticBackupStartTime: Output<String>? = null

    private var dataCompressionType: Output<String>? = null

    private var deploymentType: Output<String>? = null

    private var driveCacheType: Output<String>? = null

    private var exportPath: Output<String>? = null

    private var fileSystemTypeVersion: Output<String>? = null

    private var importPath: Output<String>? = null

    private var importedFileChunkSize: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var logConfiguration: Output<LustreFileSystemLogConfigurationArgs>? = null

    private var perUnitStorageThroughput: Output<Int>? = null

    private var rootSquashConfiguration: Output<LustreFileSystemRootSquashConfigurationArgs>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var storageCapacity: Output<Int>? = null

    private var storageType: Output<String>? = null

    private var subnetIds: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var weeklyMaintenanceStartTime: Output<String>? = null

    /**
     * @param value How Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. see [Auto Import Data Repo](https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html) for more details. Only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("gdoiotalgulvauuf")
    public suspend fun autoImportPolicy(`value`: Output<String>) {
        this.autoImportPolicy = value
    }

    /**
     * @param value The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days. only valid for `PERSISTENT_1` and `PERSISTENT_2` deployment_type.
     */
    @JvmName("isjhotjqamryvgrs")
    public suspend fun automaticBackupRetentionDays(`value`: Output<Int>) {
        this.automaticBackupRetentionDays = value
    }

    /**
     * @param value The ID of the source backup to create the filesystem from.
     */
    @JvmName("eixlxhuksekgpyqy")
    public suspend fun backupId(`value`: Output<String>) {
        this.backupId = value
    }

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to backups. Applicable for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. The default value is false.
     */
    @JvmName("nenxtouqmxthujye")
    public suspend fun copyTagsToBackups(`value`: Output<Boolean>) {
        this.copyTagsToBackups = value
    }

    /**
     * @param value A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. only valid for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Requires `automatic_backup_retention_days` to be set.
     */
    @JvmName("xtbwhrchlwqlxhgp")
    public suspend fun dailyAutomaticBackupStartTime(`value`: Output<String>) {
        this.dailyAutomaticBackupStartTime = value
    }

    /**
     * @param value Sets the data compression configuration for the file system. Valid values are `LZ4` and `NONE`. Default value is `NONE`. Unsetting this value reverts the compression type back to `NONE`.
     */
    @JvmName("pqujifoeikxymcax")
    public suspend fun dataCompressionType(`value`: Output<String>) {
        this.dataCompressionType = value
    }

    /**
     * @param value The filesystem deployment type. One of: `SCRATCH_1`, `SCRATCH_2`, `PERSISTENT_1`, `PERSISTENT_2`.
     */
    @JvmName("bgbjakcfkhbecihq")
    public suspend fun deploymentType(`value`: Output<String>) {
        this.deploymentType = value
    }

    /**
     * @param value The type of drive cache used by `PERSISTENT_1` filesystems that are provisioned with `HDD` storage_type. Required for `HDD` storage_type, set to either `READ` or `NONE`.
     */
    @JvmName("bigrrunskvdvvhjx")
    public suspend fun driveCacheType(`value`: Output<String>) {
        this.driveCacheType = value
    }

    /**
     * @param value S3 URI (with optional prefix) where the root of your Amazon FSx file system is exported. Can only be specified with `import_path` argument and the path must use the same Amazon S3 bucket as specified in `import_path`. Set equal to `import_path` to overwrite files on export. Defaults to `s3://{IMPORT BUCKET}/FSxLustre{CREATION TIMESTAMP}`. Only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("ssvriensupqddogp")
    public suspend fun exportPath(`value`: Output<String>) {
        this.exportPath = value
    }

    /**
     * @param value Sets the Lustre version for the file system that you're creating. Valid values are 2.10 for `SCRATCH_1`, `SCRATCH_2` and `PERSISTENT_1` deployment types. Valid values for 2.12 include all deployment types.
     */
    @JvmName("pteboqbbgdjwbpfv")
    public suspend fun fileSystemTypeVersion(`value`: Output<String>) {
        this.fileSystemTypeVersion = value
    }

    /**
     * @param value S3 URI (with optional prefix) that you're using as the data repository for your FSx for Lustre file system. For example, `s3://example-bucket/optional-prefix/`. Only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("iypvkxlwshwbsyul")
    public suspend fun importPath(`value`: Output<String>) {
        this.importPath = value
    }

    /**
     * @param value For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. Can only be specified with `import_path` argument. Defaults to `1024`. Minimum of `1` and maximum of `512000`. Only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("ejpysceiioyosqhi")
    public suspend fun importedFileChunkSize(`value`: Output<Int>) {
        this.importedFileChunkSize = value
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest, applicable for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Defaults to an AWS managed KMS Key.
     */
    @JvmName("wnmabcyrupyplnpa")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The Lustre logging configuration used when creating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.
     */
    @JvmName("eipyticeaubdgqxx")
    public suspend fun logConfiguration(`value`: Output<LustreFileSystemLogConfigurationArgs>) {
        this.logConfiguration = value
    }

    /**
     * @param value Describes the amount of read and write throughput for each 1 tebibyte of storage, in MB/s/TiB, required for the `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Valid values for `PERSISTENT_1` deployment_type and `SSD` storage_type are 50, 100, 200. Valid values for `PERSISTENT_1` deployment_type and `HDD` storage_type are 12, 40. Valid values for `PERSISTENT_2` deployment_type and ` SSD` storage_type are 125, 250, 500, 1000.
     */
    @JvmName("jligkvjvbyvwtnyd")
    public suspend fun perUnitStorageThroughput(`value`: Output<Int>) {
        this.perUnitStorageThroughput = value
    }

    /**
     * @param value The Lustre root squash configuration used when creating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
     */
    @JvmName("enpsjrwmhwrvwsog")
    public suspend
    fun rootSquashConfiguration(`value`: Output<LustreFileSystemRootSquashConfigurationArgs>) {
        this.rootSquashConfiguration = value
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("tgjqfdneoavblhva")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("lmejulngxttkjvwt")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("eubtcavgcowqedpp")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The storage capacity (GiB) of the file system. Minimum of `1200`. See more details at [Allowed values for Fsx storage capacity](https://docs&#46;aws&#46;amazon&#46;com/fsx/latest/APIReference/API_CreateFileSystem&#46;html#FSx-CreateFileSystem-request-StorageCapacity)&#46; Update is allowed only for `SCRATCH_2`, `PERSISTENT_1` and `PERSISTENT_2` deployment types, See more details at [Fsx Storage Capacity Update](https://docs.aws.amazon.com/fsx/latest/APIReference/API_UpdateFileSystem.html#FSx-UpdateFileSystem-request-StorageCapacity). Required when not creating filesystem for a backup.
     */
    @JvmName("ttkyklombegixkog")
    public suspend fun storageCapacity(`value`: Output<Int>) {
        this.storageCapacity = value
    }

    /**
     * @param value The filesystem storage type. Either `SSD` or `HDD`, defaults to `SSD`. `HDD` is only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("pyhsfpgvfbbjnxge")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from. File systems currently support only one subnet. The file server is also launched in that subnet's Availability Zone.
     */
    @JvmName("bjjpgnthyjrmrjjq")
    public suspend fun subnetIds(`value`: Output<String>) {
        this.subnetIds = value
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pdtjjtikftigpljd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("gfgkbqdronujrxfo")
    public suspend fun weeklyMaintenanceStartTime(`value`: Output<String>) {
        this.weeklyMaintenanceStartTime = value
    }

    /**
     * @param value How Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. see [Auto Import Data Repo](https://docs.aws.amazon.com/fsx/latest/LustreGuide/autoimport-data-repo.html) for more details. Only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("cxkxycxemvfqdkyv")
    public suspend fun autoImportPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoImportPolicy = mapped
    }

    /**
     * @param value The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days. only valid for `PERSISTENT_1` and `PERSISTENT_2` deployment_type.
     */
    @JvmName("lkbsfdrjbatrsofw")
    public suspend fun automaticBackupRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticBackupRetentionDays = mapped
    }

    /**
     * @param value The ID of the source backup to create the filesystem from.
     */
    @JvmName("jerpsrdklyqgonwk")
    public suspend fun backupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupId = mapped
    }

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to backups. Applicable for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. The default value is false.
     */
    @JvmName("uqfbitfgwkujnjpb")
    public suspend fun copyTagsToBackups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToBackups = mapped
    }

    /**
     * @param value A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. only valid for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Requires `automatic_backup_retention_days` to be set.
     */
    @JvmName("nnvgnyocgjvtqcof")
    public suspend fun dailyAutomaticBackupStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyAutomaticBackupStartTime = mapped
    }

    /**
     * @param value Sets the data compression configuration for the file system. Valid values are `LZ4` and `NONE`. Default value is `NONE`. Unsetting this value reverts the compression type back to `NONE`.
     */
    @JvmName("odaeolfmkblsysup")
    public suspend fun dataCompressionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCompressionType = mapped
    }

    /**
     * @param value The filesystem deployment type. One of: `SCRATCH_1`, `SCRATCH_2`, `PERSISTENT_1`, `PERSISTENT_2`.
     */
    @JvmName("jjqsroqjlqpxofyq")
    public suspend fun deploymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value The type of drive cache used by `PERSISTENT_1` filesystems that are provisioned with `HDD` storage_type. Required for `HDD` storage_type, set to either `READ` or `NONE`.
     */
    @JvmName("vxwbowyekxwvjesd")
    public suspend fun driveCacheType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.driveCacheType = mapped
    }

    /**
     * @param value S3 URI (with optional prefix) where the root of your Amazon FSx file system is exported. Can only be specified with `import_path` argument and the path must use the same Amazon S3 bucket as specified in `import_path`. Set equal to `import_path` to overwrite files on export. Defaults to `s3://{IMPORT BUCKET}/FSxLustre{CREATION TIMESTAMP}`. Only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("vgyxxhnligjetehq")
    public suspend fun exportPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportPath = mapped
    }

    /**
     * @param value Sets the Lustre version for the file system that you're creating. Valid values are 2.10 for `SCRATCH_1`, `SCRATCH_2` and `PERSISTENT_1` deployment types. Valid values for 2.12 include all deployment types.
     */
    @JvmName("ohroycfascmlhpuk")
    public suspend fun fileSystemTypeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemTypeVersion = mapped
    }

    /**
     * @param value S3 URI (with optional prefix) that you're using as the data repository for your FSx for Lustre file system. For example, `s3://example-bucket/optional-prefix/`. Only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("qudefetwostioquj")
    public suspend fun importPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importPath = mapped
    }

    /**
     * @param value For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. Can only be specified with `import_path` argument. Defaults to `1024`. Minimum of `1` and maximum of `512000`. Only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("vpwdghrhocetbrwg")
    public suspend fun importedFileChunkSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importedFileChunkSize = mapped
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest, applicable for `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Defaults to an AWS managed KMS Key.
     */
    @JvmName("dxomqfdsoljbhehr")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The Lustre logging configuration used when creating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.
     */
    @JvmName("fdiljnumtduvduvv")
    public suspend fun logConfiguration(`value`: LustreFileSystemLogConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfiguration = mapped
    }

    /**
     * @param argument The Lustre logging configuration used when creating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.
     */
    @JvmName("vkjdrnfttjrrwcyi")
    public suspend
    fun logConfiguration(argument: suspend LustreFileSystemLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LustreFileSystemLogConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logConfiguration = mapped
    }

    /**
     * @param value Describes the amount of read and write throughput for each 1 tebibyte of storage, in MB/s/TiB, required for the `PERSISTENT_1` and `PERSISTENT_2` deployment_type. Valid values for `PERSISTENT_1` deployment_type and `SSD` storage_type are 50, 100, 200. Valid values for `PERSISTENT_1` deployment_type and `HDD` storage_type are 12, 40. Valid values for `PERSISTENT_2` deployment_type and ` SSD` storage_type are 125, 250, 500, 1000.
     */
    @JvmName("etewmdrssphnrngh")
    public suspend fun perUnitStorageThroughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perUnitStorageThroughput = mapped
    }

    /**
     * @param value The Lustre root squash configuration used when creating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
     */
    @JvmName("woqjbonqclilmgeu")
    public suspend
    fun rootSquashConfiguration(`value`: LustreFileSystemRootSquashConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootSquashConfiguration = mapped
    }

    /**
     * @param argument The Lustre root squash configuration used when creating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.
     */
    @JvmName("grgqxtaaaqwgdfaa")
    public suspend
    fun rootSquashConfiguration(argument: suspend LustreFileSystemRootSquashConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LustreFileSystemRootSquashConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rootSquashConfiguration = mapped
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("qiwbhqhlwfoaclqe")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("pbshgopdevjvonce")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The storage capacity (GiB) of the file system. Minimum of `1200`. See more details at [Allowed values for Fsx storage capacity](https://docs&#46;aws&#46;amazon&#46;com/fsx/latest/APIReference/API_CreateFileSystem&#46;html#FSx-CreateFileSystem-request-StorageCapacity)&#46; Update is allowed only for `SCRATCH_2`, `PERSISTENT_1` and `PERSISTENT_2` deployment types, See more details at [Fsx Storage Capacity Update](https://docs.aws.amazon.com/fsx/latest/APIReference/API_UpdateFileSystem.html#FSx-UpdateFileSystem-request-StorageCapacity). Required when not creating filesystem for a backup.
     */
    @JvmName("yqjabascqsfbvibi")
    public suspend fun storageCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacity = mapped
    }

    /**
     * @param value The filesystem storage type. Either `SSD` or `HDD`, defaults to `SSD`. `HDD` is only supported on `PERSISTENT_1` deployment types.
     */
    @JvmName("qgxhktvsppbdowkn")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from. File systems currently support only one subnet. The file server is also launched in that subnet's Availability Zone.
     */
    @JvmName("cdwlsclrrqickyrp")
    public suspend fun subnetIds(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xjiunfsmavdtbene")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("clxfkxcbmbpahavc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("ceoysbcnxqmpsthe")
    public suspend fun weeklyMaintenanceStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyMaintenanceStartTime = mapped
    }

    internal fun build(): LustreFileSystemArgs = LustreFileSystemArgs(
        autoImportPolicy = autoImportPolicy,
        automaticBackupRetentionDays = automaticBackupRetentionDays,
        backupId = backupId,
        copyTagsToBackups = copyTagsToBackups,
        dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime,
        dataCompressionType = dataCompressionType,
        deploymentType = deploymentType,
        driveCacheType = driveCacheType,
        exportPath = exportPath,
        fileSystemTypeVersion = fileSystemTypeVersion,
        importPath = importPath,
        importedFileChunkSize = importedFileChunkSize,
        kmsKeyId = kmsKeyId,
        logConfiguration = logConfiguration,
        perUnitStorageThroughput = perUnitStorageThroughput,
        rootSquashConfiguration = rootSquashConfiguration,
        securityGroupIds = securityGroupIds,
        storageCapacity = storageCapacity,
        storageType = storageType,
        subnetIds = subnetIds,
        tags = tags,
        weeklyMaintenanceStartTime = weeklyMaintenanceStartTime,
    )
}
