@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemDiskIopsConfiguration
import com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemEndpoint
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemDiskIopsConfiguration.Companion.toKotlin as ontapFileSystemDiskIopsConfigurationToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemEndpoint.Companion.toKotlin as ontapFileSystemEndpointToKotlin

/**
 * Builder for [OntapFileSystem].
 */
@PulumiTagMarker
public class OntapFileSystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OntapFileSystemArgs = OntapFileSystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OntapFileSystemArgsBuilder.() -> Unit) {
        val builder = OntapFileSystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OntapFileSystem {
        val builtJavaResource = com.pulumi.aws.fsx.OntapFileSystem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OntapFileSystem(builtJavaResource)
    }
}

/**
 * Manages an Amazon FSx for NetApp ONTAP file system.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/what-is-fsx-ontap.html) for more information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapFileSystem("test", OntapFileSystemArgs.builder()
 *             .storageCapacity(1024)
 *             .subnetIds(
 *                 aws_subnet.test1().id(),
 *                 aws_subnet.test2().id())
 *             .deploymentType("MULTI_AZ_1")
 *             .throughputCapacity(512)
 *             .preferredSubnetId(aws_subnet.test1().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:fsx/ontapFileSystem:OntapFileSystem example fs-543ab12b1ca672f33
 * ```
 *  Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 */
public class OntapFileSystem internal constructor(
    override val javaResource: com.pulumi.aws.fsx.OntapFileSystem,
) : KotlinCustomResource(javaResource, OntapFileSystemMapper) {
    /**
     * Amazon Resource Name of the file system.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    public val automaticBackupRetentionDays: Output<Int>?
        get() = javaResource.automaticBackupRetentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    public val dailyAutomaticBackupStartTime: Output<String>
        get() = javaResource.dailyAutomaticBackupStartTime().applyValue({ args0 -> args0 })

    /**
     * The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
     */
    public val deploymentType: Output<String>
        get() = javaResource.deploymentType().applyValue({ args0 -> args0 })

    /**
     * The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
     */
    public val diskIopsConfiguration: Output<OntapFileSystemDiskIopsConfiguration>
        get() = javaResource.diskIopsConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                ontapFileSystemDiskIopsConfigurationToKotlin(args0)
            })
        })

    /**
     * The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
     */
    public val endpointIpAddressRange: Output<String>
        get() = javaResource.endpointIpAddressRange().applyValue({ args0 -> args0 })

    /**
     * The endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See Endpoints below.
     */
    public val endpoints: Output<List<OntapFileSystemEndpoint>>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ontapFileSystemEndpointToKotlin(args0)
                })
            })
        })

    /**
     * The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
     */
    public val fsxAdminPassword: Output<String>?
        get() = javaResource.fsxAdminPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
     */
    public val networkInterfaceIds: Output<List<String>>
        get() = javaResource.networkInterfaceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * AWS account identifier that created the file system.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
     */
    public val preferredSubnetId: Output<String>
        get() = javaResource.preferredSubnetId().applyValue({ args0 -> args0 })

    /**
     * Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    public val routeTableIds: Output<List<String>>
        get() = javaResource.routeTableIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
     */
    public val storageCapacity: Output<Int>?
        get() = javaResource.storageCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The filesystem storage type. defaults to `SSD`.
     */
    public val storageType: Output<String>?
        get() = javaResource.storageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of IDs for the subnets that the file system will be accessible from. Upto 2 subnets can be provided.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`.
     */
    public val throughputCapacity: Output<Int>
        get() = javaResource.throughputCapacity().applyValue({ args0 -> args0 })

    /**
     * Identifier of the Virtual Private Cloud for the file system.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    public val weeklyMaintenanceStartTime: Output<String>
        get() = javaResource.weeklyMaintenanceStartTime().applyValue({ args0 -> args0 })
}

public object OntapFileSystemMapper : ResourceMapper<OntapFileSystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.OntapFileSystem::class == javaResource::class

    override fun map(javaResource: Resource): OntapFileSystem = OntapFileSystem(
        javaResource as
            com.pulumi.aws.fsx.OntapFileSystem,
    )
}

/**
 * @see [OntapFileSystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OntapFileSystem].
 */
public suspend fun ontapFileSystem(
    name: String,
    block: suspend OntapFileSystemResourceBuilder.() -> Unit,
): OntapFileSystem {
    val builder = OntapFileSystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OntapFileSystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ontapFileSystem(name: String): OntapFileSystem {
    val builder = OntapFileSystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
