@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.OntapFileSystemArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.OntapFileSystemDiskIopsConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.OntapFileSystemDiskIopsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon FSx for NetApp ONTAP file system.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/what-is-fsx-ontap.html) for more information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapFileSystem("test", OntapFileSystemArgs.builder()
 *             .storageCapacity(1024)
 *             .subnetIds(
 *                 aws_subnet.test1().id(),
 *                 aws_subnet.test2().id())
 *             .deploymentType("MULTI_AZ_1")
 *             .throughputCapacity(512)
 *             .preferredSubnetId(aws_subnet.test1().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:fsx/ontapFileSystem:OntapFileSystem example fs-543ab12b1ca672f33
 * ```
 *  Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property automaticBackupRetentionDays The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
 * @property dailyAutomaticBackupStartTime A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
 * @property deploymentType The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
 * @property diskIopsConfiguration The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
 * @property endpointIpAddressRange Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
 * @property fsxAdminPassword The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
 * @property kmsKeyId ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
 * @property preferredSubnetId The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
 * @property routeTableIds Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
 * @property securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
 * @property storageCapacity The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
 * @property storageType The filesystem storage type. defaults to `SSD`.
 * @property subnetIds A list of IDs for the subnets that the file system will be accessible from. Upto 2 subnets can be provided.
 * @property tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property throughputCapacity Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`.
 * @property weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
 */
public data class OntapFileSystemArgs(
    public val automaticBackupRetentionDays: Output<Int>? = null,
    public val dailyAutomaticBackupStartTime: Output<String>? = null,
    public val deploymentType: Output<String>? = null,
    public val diskIopsConfiguration: Output<OntapFileSystemDiskIopsConfigurationArgs>? = null,
    public val endpointIpAddressRange: Output<String>? = null,
    public val fsxAdminPassword: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val preferredSubnetId: Output<String>? = null,
    public val routeTableIds: Output<List<String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val storageCapacity: Output<Int>? = null,
    public val storageType: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputCapacity: Output<Int>? = null,
    public val weeklyMaintenanceStartTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.OntapFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.fsx.OntapFileSystemArgs =
        com.pulumi.aws.fsx.OntapFileSystemArgs.builder()
            .automaticBackupRetentionDays(automaticBackupRetentionDays?.applyValue({ args0 -> args0 }))
            .dailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime?.applyValue({ args0 -> args0 }))
            .deploymentType(deploymentType?.applyValue({ args0 -> args0 }))
            .diskIopsConfiguration(
                diskIopsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .endpointIpAddressRange(endpointIpAddressRange?.applyValue({ args0 -> args0 }))
            .fsxAdminPassword(fsxAdminPassword?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .preferredSubnetId(preferredSubnetId?.applyValue({ args0 -> args0 }))
            .routeTableIds(routeTableIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageCapacity(storageCapacity?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputCapacity(throughputCapacity?.applyValue({ args0 -> args0 }))
            .weeklyMaintenanceStartTime(weeklyMaintenanceStartTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapFileSystemArgs].
 */
@PulumiTagMarker
public class OntapFileSystemArgsBuilder internal constructor() {
    private var automaticBackupRetentionDays: Output<Int>? = null

    private var dailyAutomaticBackupStartTime: Output<String>? = null

    private var deploymentType: Output<String>? = null

    private var diskIopsConfiguration: Output<OntapFileSystemDiskIopsConfigurationArgs>? = null

    private var endpointIpAddressRange: Output<String>? = null

    private var fsxAdminPassword: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var preferredSubnetId: Output<String>? = null

    private var routeTableIds: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var storageCapacity: Output<Int>? = null

    private var storageType: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputCapacity: Output<Int>? = null

    private var weeklyMaintenanceStartTime: Output<String>? = null

    /**
     * @param value The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    @JvmName("yebgmggitjluqnqo")
    public suspend fun automaticBackupRetentionDays(`value`: Output<Int>) {
        this.automaticBackupRetentionDays = value
    }

    /**
     * @param value A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    @JvmName("kjvxrjspweiqmpgu")
    public suspend fun dailyAutomaticBackupStartTime(`value`: Output<String>) {
        this.dailyAutomaticBackupStartTime = value
    }

    /**
     * @param value The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
     */
    @JvmName("xescetvveatcsvan")
    public suspend fun deploymentType(`value`: Output<String>) {
        this.deploymentType = value
    }

    /**
     * @param value The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
     */
    @JvmName("bqfshpfrkpunakcr")
    public suspend
    fun diskIopsConfiguration(`value`: Output<OntapFileSystemDiskIopsConfigurationArgs>) {
        this.diskIopsConfiguration = value
    }

    /**
     * @param value Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
     */
    @JvmName("qleicqalkrgxwqsy")
    public suspend fun endpointIpAddressRange(`value`: Output<String>) {
        this.endpointIpAddressRange = value
    }

    /**
     * @param value The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
     */
    @JvmName("abomkfqikjhlrmba")
    public suspend fun fsxAdminPassword(`value`: Output<String>) {
        this.fsxAdminPassword = value
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    @JvmName("uqeubeoamcforiqm")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
     */
    @JvmName("gledptrtpluyoqei")
    public suspend fun preferredSubnetId(`value`: Output<String>) {
        this.preferredSubnetId = value
    }

    /**
     * @param value Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("krxswcgrbwglmpke")
    public suspend fun routeTableIds(`value`: Output<List<String>>) {
        this.routeTableIds = value
    }

    @JvmName("aaieaorxohlepinr")
    public suspend fun routeTableIds(vararg values: Output<String>) {
        this.routeTableIds = Output.all(values.asList())
    }

    /**
     * @param values Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("jetemlybarnoxvuj")
    public suspend fun routeTableIds(values: List<Output<String>>) {
        this.routeTableIds = Output.all(values)
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("esiqddcaggkuwmnj")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("nugjofcujfascptj")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("tbpiqehvnkvurmbm")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
     */
    @JvmName("vlfedjybvewwcjuk")
    public suspend fun storageCapacity(`value`: Output<Int>) {
        this.storageCapacity = value
    }

    /**
     * @param value The filesystem storage type. defaults to `SSD`.
     */
    @JvmName("ervglcuivolfbrka")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from. Upto 2 subnets can be provided.
     */
    @JvmName("cqcxafkyfotihaqq")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("uluvxyrmooqnvsin")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the subnets that the file system will be accessible from. Upto 2 subnets can be provided.
     */
    @JvmName("ixrthxwmggagcavd")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ewxjemxrwnxjaqbr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`.
     */
    @JvmName("jmacalvxjjjtasbj")
    public suspend fun throughputCapacity(`value`: Output<Int>) {
        this.throughputCapacity = value
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("vqltiwpyhyewvtvi")
    public suspend fun weeklyMaintenanceStartTime(`value`: Output<String>) {
        this.weeklyMaintenanceStartTime = value
    }

    /**
     * @param value The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    @JvmName("pwtpgdqjhdilhysw")
    public suspend fun automaticBackupRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticBackupRetentionDays = mapped
    }

    /**
     * @param value A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    @JvmName("lagfksddlddylvuu")
    public suspend fun dailyAutomaticBackupStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyAutomaticBackupStartTime = mapped
    }

    /**
     * @param value The filesystem deployment type. Supports `MULTI_AZ_1` and `SINGLE_AZ_1`.
     */
    @JvmName("iivydracuqjfrcac")
    public suspend fun deploymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
     */
    @JvmName("ddwtkllwmfiplsvp")
    public suspend fun diskIopsConfiguration(`value`: OntapFileSystemDiskIopsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIopsConfiguration = mapped
    }

    /**
     * @param argument The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
     */
    @JvmName("yidciqcncjbygbmr")
    public suspend
    fun diskIopsConfiguration(argument: suspend OntapFileSystemDiskIopsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OntapFileSystemDiskIopsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.diskIopsConfiguration = mapped
    }

    /**
     * @param value Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
     */
    @JvmName("kreltshfqibhtvlc")
    public suspend fun endpointIpAddressRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointIpAddressRange = mapped
    }

    /**
     * @param value The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
     */
    @JvmName("gvkvwnirjqdgnufg")
    public suspend fun fsxAdminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsxAdminPassword = mapped
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    @JvmName("kgxtgxcatukqqeen")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
     */
    @JvmName("dkbgjydvptkbdwru")
    public suspend fun preferredSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredSubnetId = mapped
    }

    /**
     * @param value Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("vjyvwkjuucrdcdhb")
    public suspend fun routeTableIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableIds = mapped
    }

    /**
     * @param values Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("jqybytoivftedplt")
    public suspend fun routeTableIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeTableIds = mapped
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("osseuxtlitdjghoh")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("kvhmahhsfcsaecls")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The storage capacity (GiB) of the file system. Valid values between `1024` and `196608`.
     */
    @JvmName("mmkqgknvdfmjyxum")
    public suspend fun storageCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacity = mapped
    }

    /**
     * @param value The filesystem storage type. defaults to `SSD`.
     */
    @JvmName("ysjqtaurknahtytu")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from. Upto 2 subnets can be provided.
     */
    @JvmName("jegsqtvcxysraxqd")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of IDs for the subnets that the file system will be accessible from. Upto 2 subnets can be provided.
     */
    @JvmName("brpnrygmbbqlxyxo")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("krksslbhweshllqb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xabiyosdjciasodb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`.
     */
    @JvmName("tcpjqyldfvqjfdor")
    public suspend fun throughputCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputCapacity = mapped
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("uyjthrvsnitucvlb")
    public suspend fun weeklyMaintenanceStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyMaintenanceStartTime = mapped
    }

    internal fun build(): OntapFileSystemArgs = OntapFileSystemArgs(
        automaticBackupRetentionDays = automaticBackupRetentionDays,
        dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime,
        deploymentType = deploymentType,
        diskIopsConfiguration = diskIopsConfiguration,
        endpointIpAddressRange = endpointIpAddressRange,
        fsxAdminPassword = fsxAdminPassword,
        kmsKeyId = kmsKeyId,
        preferredSubnetId = preferredSubnetId,
        routeTableIds = routeTableIds,
        securityGroupIds = securityGroupIds,
        storageCapacity = storageCapacity,
        storageType = storageType,
        subnetIds = subnetIds,
        tags = tags,
        throughputCapacity = throughputCapacity,
        weeklyMaintenanceStartTime = weeklyMaintenanceStartTime,
    )
}
