@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.OntapVolumeArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeSnaplockConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeSnaplockConfigurationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeTieringPolicyArgs
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeTieringPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a FSx ONTAP Volume.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html) for more information.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapVolume;
 * import com.pulumi.aws.fsx.OntapVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapVolume("test", OntapVolumeArgs.builder()
 *             .junctionPath("/test")
 *             .sizeInMegabytes(1024)
 *             .storageEfficiencyEnabled(true)
 *             .storageVirtualMachineId(aws_fsx_ontap_storage_virtual_machine.test().id())
 *             .build());
 *     }
 * }
 * ```
 * ### Using Tiering Policy
 * Additional information on tiering policy with ONTAP Volumes can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapVolume;
 * import com.pulumi.aws.fsx.OntapVolumeArgs;
 * import com.pulumi.aws.fsx.inputs.OntapVolumeTieringPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapVolume("test", OntapVolumeArgs.builder()
 *             .junctionPath("/test")
 *             .sizeInMegabytes(1024)
 *             .storageEfficiencyEnabled(true)
 *             .storageVirtualMachineId(aws_fsx_ontap_storage_virtual_machine.test().id())
 *             .tieringPolicy(OntapVolumeTieringPolicyArgs.builder()
 *                 .name("AUTO")
 *                 .coolingPeriod(31)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import FSx ONTAP volume using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:fsx/ontapVolume:OntapVolume example fsvol-12345678abcdef123
 * ```
 * @property bypassSnaplockEnterpriseRetention Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
 * @property copyTagsToBackups A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
 * @property junctionPath Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
 * @property name The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
 * @property ontapVolumeType Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
 * @property securityStyle Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
 * @property sizeInMegabytes Specifies the size of the volume, in megabytes (MB), that you are creating.
 * @property skipFinalBackup When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
 * @property snaplockConfiguration The SnapLock configuration for an FSx for ONTAP volume. See SnapLock Configuration below.
 * @property snapshotPolicy Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
 * @property storageEfficiencyEnabled Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
 * @property storageVirtualMachineId Specifies the storage virtual machine in which to create the volume.
 * @property tags A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tieringPolicy The data tiering policy for an FSx for ONTAP volume. See Tiering Policy below.
 * @property volumeType The type of volume, currently the only valid value is `ONTAP`.
 */
public data class OntapVolumeArgs(
    public val bypassSnaplockEnterpriseRetention: Output<Boolean>? = null,
    public val copyTagsToBackups: Output<Boolean>? = null,
    public val junctionPath: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ontapVolumeType: Output<String>? = null,
    public val securityStyle: Output<String>? = null,
    public val sizeInMegabytes: Output<Int>? = null,
    public val skipFinalBackup: Output<Boolean>? = null,
    public val snaplockConfiguration: Output<OntapVolumeSnaplockConfigurationArgs>? = null,
    public val snapshotPolicy: Output<String>? = null,
    public val storageEfficiencyEnabled: Output<Boolean>? = null,
    public val storageVirtualMachineId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tieringPolicy: Output<OntapVolumeTieringPolicyArgs>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.OntapVolumeArgs> {
    override fun toJava(): com.pulumi.aws.fsx.OntapVolumeArgs =
        com.pulumi.aws.fsx.OntapVolumeArgs.builder()
            .bypassSnaplockEnterpriseRetention(
                bypassSnaplockEnterpriseRetention?.applyValue({ args0 ->
                    args0
                }),
            )
            .copyTagsToBackups(copyTagsToBackups?.applyValue({ args0 -> args0 }))
            .junctionPath(junctionPath?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ontapVolumeType(ontapVolumeType?.applyValue({ args0 -> args0 }))
            .securityStyle(securityStyle?.applyValue({ args0 -> args0 }))
            .sizeInMegabytes(sizeInMegabytes?.applyValue({ args0 -> args0 }))
            .skipFinalBackup(skipFinalBackup?.applyValue({ args0 -> args0 }))
            .snaplockConfiguration(
                snaplockConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .snapshotPolicy(snapshotPolicy?.applyValue({ args0 -> args0 }))
            .storageEfficiencyEnabled(storageEfficiencyEnabled?.applyValue({ args0 -> args0 }))
            .storageVirtualMachineId(storageVirtualMachineId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tieringPolicy(tieringPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapVolumeArgs].
 */
@PulumiTagMarker
public class OntapVolumeArgsBuilder internal constructor() {
    private var bypassSnaplockEnterpriseRetention: Output<Boolean>? = null

    private var copyTagsToBackups: Output<Boolean>? = null

    private var junctionPath: Output<String>? = null

    private var name: Output<String>? = null

    private var ontapVolumeType: Output<String>? = null

    private var securityStyle: Output<String>? = null

    private var sizeInMegabytes: Output<Int>? = null

    private var skipFinalBackup: Output<Boolean>? = null

    private var snaplockConfiguration: Output<OntapVolumeSnaplockConfigurationArgs>? = null

    private var snapshotPolicy: Output<String>? = null

    private var storageEfficiencyEnabled: Output<Boolean>? = null

    private var storageVirtualMachineId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tieringPolicy: Output<OntapVolumeTieringPolicyArgs>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("vskienqsawnutwdx")
    public suspend fun bypassSnaplockEnterpriseRetention(`value`: Output<Boolean>) {
        this.bypassSnaplockEnterpriseRetention = value
    }

    /**
     * @param value A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
     */
    @JvmName("yxkildstfexmnydq")
    public suspend fun copyTagsToBackups(`value`: Output<Boolean>) {
        this.copyTagsToBackups = value
    }

    /**
     * @param value Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
     */
    @JvmName("rqejelilnqvedeip")
    public suspend fun junctionPath(`value`: Output<String>) {
        this.junctionPath = value
    }

    /**
     * @param value The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     */
    @JvmName("jpipwiqrlysgjhlg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
     */
    @JvmName("aagspadjkusnvyar")
    public suspend fun ontapVolumeType(`value`: Output<String>) {
        this.ontapVolumeType = value
    }

    /**
     * @param value Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
     */
    @JvmName("tdykjgxtolrldrfa")
    public suspend fun securityStyle(`value`: Output<String>) {
        this.securityStyle = value
    }

    /**
     * @param value Specifies the size of the volume, in megabytes (MB), that you are creating.
     */
    @JvmName("skcytpoexrqimiks")
    public suspend fun sizeInMegabytes(`value`: Output<Int>) {
        this.sizeInMegabytes = value
    }

    /**
     * @param value When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("mdvcmylfdwrxfudn")
    public suspend fun skipFinalBackup(`value`: Output<Boolean>) {
        this.skipFinalBackup = value
    }

    /**
     * @param value The SnapLock configuration for an FSx for ONTAP volume. See SnapLock Configuration below.
     */
    @JvmName("twrsxghinmoptixd")
    public suspend fun snaplockConfiguration(`value`: Output<OntapVolumeSnaplockConfigurationArgs>) {
        this.snaplockConfiguration = value
    }

    /**
     * @param value Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
     */
    @JvmName("aoelflbbqiiffwtt")
    public suspend fun snapshotPolicy(`value`: Output<String>) {
        this.snapshotPolicy = value
    }

    /**
     * @param value Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     */
    @JvmName("wdejoljddeoivqra")
    public suspend fun storageEfficiencyEnabled(`value`: Output<Boolean>) {
        this.storageEfficiencyEnabled = value
    }

    /**
     * @param value Specifies the storage virtual machine in which to create the volume.
     */
    @JvmName("hchoodiuopgogxxk")
    public suspend fun storageVirtualMachineId(`value`: Output<String>) {
        this.storageVirtualMachineId = value
    }

    /**
     * @param value A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wpceatcndrljjfhc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The data tiering policy for an FSx for ONTAP volume. See Tiering Policy below.
     */
    @JvmName("asbhtckvnejybylv")
    public suspend fun tieringPolicy(`value`: Output<OntapVolumeTieringPolicyArgs>) {
        this.tieringPolicy = value
    }

    /**
     * @param value The type of volume, currently the only valid value is `ONTAP`.
     */
    @JvmName("qdcwbtqufgwvahmc")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("pdsvynwriatkpqjg")
    public suspend fun bypassSnaplockEnterpriseRetention(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassSnaplockEnterpriseRetention = mapped
    }

    /**
     * @param value A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
     */
    @JvmName("lufwgogfflgesncc")
    public suspend fun copyTagsToBackups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToBackups = mapped
    }

    /**
     * @param value Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
     */
    @JvmName("aeqkkpulibcghfih")
    public suspend fun junctionPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.junctionPath = mapped
    }

    /**
     * @param value The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     */
    @JvmName("gyovebwdllmmiqqq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
     */
    @JvmName("gyhivkhckstbpvnl")
    public suspend fun ontapVolumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ontapVolumeType = mapped
    }

    /**
     * @param value Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
     */
    @JvmName("kowbrsrvedjuhxjc")
    public suspend fun securityStyle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityStyle = mapped
    }

    /**
     * @param value Specifies the size of the volume, in megabytes (MB), that you are creating.
     */
    @JvmName("sxvophrajnjbyyos")
    public suspend fun sizeInMegabytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeInMegabytes = mapped
    }

    /**
     * @param value When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("rnysbfrwiawjincy")
    public suspend fun skipFinalBackup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalBackup = mapped
    }

    /**
     * @param value The SnapLock configuration for an FSx for ONTAP volume. See SnapLock Configuration below.
     */
    @JvmName("xigtmmljrlpaixsk")
    public suspend fun snaplockConfiguration(`value`: OntapVolumeSnaplockConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snaplockConfiguration = mapped
    }

    /**
     * @param argument The SnapLock configuration for an FSx for ONTAP volume. See SnapLock Configuration below.
     */
    @JvmName("tgjmjkyweejsipxp")
    public suspend
    fun snaplockConfiguration(argument: suspend OntapVolumeSnaplockConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OntapVolumeSnaplockConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.snaplockConfiguration = mapped
    }

    /**
     * @param value Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
     */
    @JvmName("jokcjttykjvwhsat")
    public suspend fun snapshotPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotPolicy = mapped
    }

    /**
     * @param value Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     */
    @JvmName("dukxriquomkkyflq")
    public suspend fun storageEfficiencyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEfficiencyEnabled = mapped
    }

    /**
     * @param value Specifies the storage virtual machine in which to create the volume.
     */
    @JvmName("lwatjjieonddhfiq")
    public suspend fun storageVirtualMachineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageVirtualMachineId = mapped
    }

    /**
     * @param value A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vdbhayonadtuveba")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xabmrmthwusvscjy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The data tiering policy for an FSx for ONTAP volume. See Tiering Policy below.
     */
    @JvmName("oqxlmuqvsbkevoii")
    public suspend fun tieringPolicy(`value`: OntapVolumeTieringPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tieringPolicy = mapped
    }

    /**
     * @param argument The data tiering policy for an FSx for ONTAP volume. See Tiering Policy below.
     */
    @JvmName("vfdrmrtsxqytyskv")
    public suspend
    fun tieringPolicy(argument: suspend OntapVolumeTieringPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = OntapVolumeTieringPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tieringPolicy = mapped
    }

    /**
     * @param value The type of volume, currently the only valid value is `ONTAP`.
     */
    @JvmName("trupfgpnainnrghh")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): OntapVolumeArgs = OntapVolumeArgs(
        bypassSnaplockEnterpriseRetention = bypassSnaplockEnterpriseRetention,
        copyTagsToBackups = copyTagsToBackups,
        junctionPath = junctionPath,
        name = name,
        ontapVolumeType = ontapVolumeType,
        securityStyle = securityStyle,
        sizeInMegabytes = sizeInMegabytes,
        skipFinalBackup = skipFinalBackup,
        snaplockConfiguration = snaplockConfiguration,
        snapshotPolicy = snapshotPolicy,
        storageEfficiencyEnabled = storageEfficiencyEnabled,
        storageVirtualMachineId = storageVirtualMachineId,
        tags = tags,
        tieringPolicy = tieringPolicy,
        volumeType = volumeType,
    )
}
