@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [OpenZfsSnapshot].
 */
@PulumiTagMarker
public class OpenZfsSnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OpenZfsSnapshotArgs = OpenZfsSnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OpenZfsSnapshotArgsBuilder.() -> Unit) {
        val builder = OpenZfsSnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OpenZfsSnapshot {
        val builtJavaResource = com.pulumi.aws.fsx.OpenZfsSnapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OpenZfsSnapshot(builtJavaResource)
    }
}

/**
 * Manages an Amazon FSx for OpenZFS volume.
 * See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.
 * ## Example Usage
 * ### Root volume Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsFileSystem;
 * import com.pulumi.aws.fsx.OpenZfsFileSystemArgs;
 * import com.pulumi.aws.fsx.OpenZfsSnapshot;
 * import com.pulumi.aws.fsx.OpenZfsSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOpenZfsFileSystem = new OpenZfsFileSystem("exampleOpenZfsFileSystem", OpenZfsFileSystemArgs.builder()
 *             .storageCapacity(64)
 *             .subnetIds(aws_subnet.example().id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .throughputCapacity(64)
 *             .build());
 *         var exampleOpenZfsSnapshot = new OpenZfsSnapshot("exampleOpenZfsSnapshot", OpenZfsSnapshotArgs.builder()
 *             .volumeId(exampleOpenZfsFileSystem.rootVolumeId())
 *             .build());
 *     }
 * }
 * ```
 * ### Child volume Example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsFileSystem;
 * import com.pulumi.aws.fsx.OpenZfsFileSystemArgs;
 * import com.pulumi.aws.fsx.OpenZfsVolume;
 * import com.pulumi.aws.fsx.OpenZfsVolumeArgs;
 * import com.pulumi.aws.fsx.OpenZfsSnapshot;
 * import com.pulumi.aws.fsx.OpenZfsSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOpenZfsFileSystem = new OpenZfsFileSystem("exampleOpenZfsFileSystem", OpenZfsFileSystemArgs.builder()
 *             .storageCapacity(64)
 *             .subnetIds(aws_subnet.example().id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .throughputCapacity(64)
 *             .build());
 *         var exampleOpenZfsVolume = new OpenZfsVolume("exampleOpenZfsVolume", OpenZfsVolumeArgs.builder()
 *             .parentVolumeId(exampleOpenZfsFileSystem.rootVolumeId())
 *             .build());
 *         var exampleOpenZfsSnapshot = new OpenZfsSnapshot("exampleOpenZfsSnapshot", OpenZfsSnapshotArgs.builder()
 *             .volumeId(exampleOpenZfsVolume.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import FSx OpenZFS snapshot using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:fsx/openZfsSnapshot:OpenZfsSnapshot example fs-543ab12b1ca672f33
 * ```
 *
 */
public class OpenZfsSnapshot internal constructor(
    override val javaResource: com.pulumi.aws.fsx.OpenZfsSnapshot,
) : KotlinCustomResource(javaResource, OpenZfsSnapshotMapper) {
    /**
     * Amazon Resource Name of the snapshot.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The name of the Snapshot. You can use a maximum of 203 alphanumeric characters plus either _ or -  or : or . for the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the volume to snapshot. This can be the root volume or a child volume.
     */
    public val volumeId: Output<String>
        get() = javaResource.volumeId().applyValue({ args0 -> args0 })
}

public object OpenZfsSnapshotMapper : ResourceMapper<OpenZfsSnapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.OpenZfsSnapshot::class == javaResource::class

    override fun map(javaResource: Resource): OpenZfsSnapshot = OpenZfsSnapshot(
        javaResource as
            com.pulumi.aws.fsx.OpenZfsSnapshot,
    )
}

/**
 * @see [OpenZfsSnapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OpenZfsSnapshot].
 */
public suspend fun openZfsSnapshot(
    name: String,
    block: suspend OpenZfsSnapshotResourceBuilder.() -> Unit,
): OpenZfsSnapshot {
    val builder = OpenZfsSnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OpenZfsSnapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun openZfsSnapshot(name: String): OpenZfsSnapshot {
    val builder = OpenZfsSnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
