@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.WindowsFileSystemArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.WindowsFileSystemAuditLogConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.WindowsFileSystemAuditLogConfigurationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.WindowsFileSystemDiskIopsConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.WindowsFileSystemDiskIopsConfigurationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgs
import com.pulumi.aws.fsx.kotlin.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a FSx Windows File System. See the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html) for more information.
 * > **NOTE:** Either the `active_directory_id` argument or `self_managed_active_directory` configuration block must be specified.
 * ## Example Usage
 * ### Using AWS Directory Service
 * Additional information for using AWS Directory Service with Windows File Systems can be found in the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/fsx-aws-managed-ad.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.WindowsFileSystem;
 * import com.pulumi.aws.fsx.WindowsFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WindowsFileSystem("example", WindowsFileSystemArgs.builder()
 *             .activeDirectoryId(aws_directory_service_directory.example().id())
 *             .kmsKeyId(aws_kms_key.example().arn())
 *             .storageCapacity(300)
 *             .subnetIds(aws_subnet.example().id())
 *             .throughputCapacity(1024)
 *             .build());
 *     }
 * }
 * ```
 * ### Using a Self-Managed Microsoft Active Directory
 * Additional information for using AWS Directory Service with Windows File Systems can be found in the [FSx Windows Guide](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.WindowsFileSystem;
 * import com.pulumi.aws.fsx.WindowsFileSystemArgs;
 * import com.pulumi.aws.fsx.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WindowsFileSystem("example", WindowsFileSystemArgs.builder()
 *             .kmsKeyId(aws_kms_key.example().arn())
 *             .storageCapacity(300)
 *             .subnetIds(aws_subnet.example().id())
 *             .throughputCapacity(1024)
 *             .selfManagedActiveDirectory(WindowsFileSystemSelfManagedActiveDirectoryArgs.builder()
 *                 .dnsIps(
 *                     "10.0.0.111",
 *                     "10.0.0.222")
 *                 .domainName("corp.example.com")
 *                 .password("avoid-plaintext-passwords")
 *                 .username("Admin")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:fsx/windowsFileSystem:WindowsFileSystem example fs-543ab12b1ca672f33
 * ```
 *  Certain resource arguments, like `security_group_ids` and the `self_managed_active_directory` configuation block `password`, do not have a FSx API method for reading the information after creation. If these arguments are set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property activeDirectoryId The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
 * @property aliases An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
 * @property auditLogConfiguration The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
 * @property automaticBackupRetentionDays The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
 * @property backupId The ID of the source backup to create the filesystem from.
 * @property copyTagsToBackups A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
 * @property dailyAutomaticBackupStartTime The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
 * @property deploymentType Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
 * @property diskIopsConfiguration The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
 * @property kmsKeyId ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
 * @property preferredSubnetId Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
 * @property securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
 * @property selfManagedActiveDirectory Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
 * @property skipFinalBackup When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
 * @property storageCapacity Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
 * @property storageType Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
 * @property subnetIds A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
 * @property tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property throughputCapacity Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
 * The following arguments are optional:
 * @property weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
 */
public data class WindowsFileSystemArgs(
    public val activeDirectoryId: Output<String>? = null,
    public val aliases: Output<List<String>>? = null,
    public val auditLogConfiguration: Output<WindowsFileSystemAuditLogConfigurationArgs>? = null,
    public val automaticBackupRetentionDays: Output<Int>? = null,
    public val backupId: Output<String>? = null,
    public val copyTagsToBackups: Output<Boolean>? = null,
    public val dailyAutomaticBackupStartTime: Output<String>? = null,
    public val deploymentType: Output<String>? = null,
    public val diskIopsConfiguration: Output<WindowsFileSystemDiskIopsConfigurationArgs>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val preferredSubnetId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val selfManagedActiveDirectory: Output<WindowsFileSystemSelfManagedActiveDirectoryArgs>? =
        null,
    public val skipFinalBackup: Output<Boolean>? = null,
    public val storageCapacity: Output<Int>? = null,
    public val storageType: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputCapacity: Output<Int>? = null,
    public val weeklyMaintenanceStartTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.WindowsFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.fsx.WindowsFileSystemArgs =
        com.pulumi.aws.fsx.WindowsFileSystemArgs.builder()
            .activeDirectoryId(activeDirectoryId?.applyValue({ args0 -> args0 }))
            .aliases(aliases?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .auditLogConfiguration(
                auditLogConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .automaticBackupRetentionDays(automaticBackupRetentionDays?.applyValue({ args0 -> args0 }))
            .backupId(backupId?.applyValue({ args0 -> args0 }))
            .copyTagsToBackups(copyTagsToBackups?.applyValue({ args0 -> args0 }))
            .dailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime?.applyValue({ args0 -> args0 }))
            .deploymentType(deploymentType?.applyValue({ args0 -> args0 }))
            .diskIopsConfiguration(
                diskIopsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .preferredSubnetId(preferredSubnetId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .selfManagedActiveDirectory(
                selfManagedActiveDirectory?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .skipFinalBackup(skipFinalBackup?.applyValue({ args0 -> args0 }))
            .storageCapacity(storageCapacity?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputCapacity(throughputCapacity?.applyValue({ args0 -> args0 }))
            .weeklyMaintenanceStartTime(weeklyMaintenanceStartTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsFileSystemArgs].
 */
@PulumiTagMarker
public class WindowsFileSystemArgsBuilder internal constructor() {
    private var activeDirectoryId: Output<String>? = null

    private var aliases: Output<List<String>>? = null

    private var auditLogConfiguration: Output<WindowsFileSystemAuditLogConfigurationArgs>? = null

    private var automaticBackupRetentionDays: Output<Int>? = null

    private var backupId: Output<String>? = null

    private var copyTagsToBackups: Output<Boolean>? = null

    private var dailyAutomaticBackupStartTime: Output<String>? = null

    private var deploymentType: Output<String>? = null

    private var diskIopsConfiguration: Output<WindowsFileSystemDiskIopsConfigurationArgs>? = null

    private var kmsKeyId: Output<String>? = null

    private var preferredSubnetId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var selfManagedActiveDirectory: Output<WindowsFileSystemSelfManagedActiveDirectoryArgs>? =
        null

    private var skipFinalBackup: Output<Boolean>? = null

    private var storageCapacity: Output<Int>? = null

    private var storageType: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputCapacity: Output<Int>? = null

    private var weeklyMaintenanceStartTime: Output<String>? = null

    /**
     * @param value The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
     */
    @JvmName("vmwyfriqgskhkpjh")
    public suspend fun activeDirectoryId(`value`: Output<String>) {
        this.activeDirectoryId = value
    }

    /**
     * @param value An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
     */
    @JvmName("uyrdispabvivmkel")
    public suspend fun aliases(`value`: Output<List<String>>) {
        this.aliases = value
    }

    @JvmName("gfqxajjyukfuqfpg")
    public suspend fun aliases(vararg values: Output<String>) {
        this.aliases = Output.all(values.asList())
    }

    /**
     * @param values An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
     */
    @JvmName("ttpopkseugxysajr")
    public suspend fun aliases(values: List<Output<String>>) {
        this.aliases = Output.all(values)
    }

    /**
     * @param value The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
     */
    @JvmName("wmojtpsyjjpkwmls")
    public suspend
    fun auditLogConfiguration(`value`: Output<WindowsFileSystemAuditLogConfigurationArgs>) {
        this.auditLogConfiguration = value
    }

    /**
     * @param value The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
     */
    @JvmName("aosroctjquprbbqc")
    public suspend fun automaticBackupRetentionDays(`value`: Output<Int>) {
        this.automaticBackupRetentionDays = value
    }

    /**
     * @param value The ID of the source backup to create the filesystem from.
     */
    @JvmName("memmnhkxpftuubkw")
    public suspend fun backupId(`value`: Output<String>) {
        this.backupId = value
    }

    /**
     * @param value A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
     */
    @JvmName("oyttdhmxolhihrcs")
    public suspend fun copyTagsToBackups(`value`: Output<Boolean>) {
        this.copyTagsToBackups = value
    }

    /**
     * @param value The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
     */
    @JvmName("mmlhmeykfpegctcx")
    public suspend fun dailyAutomaticBackupStartTime(`value`: Output<String>) {
        this.dailyAutomaticBackupStartTime = value
    }

    /**
     * @param value Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
     */
    @JvmName("nkmgwfmdofuganvd")
    public suspend fun deploymentType(`value`: Output<String>) {
        this.deploymentType = value
    }

    /**
     * @param value The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
     */
    @JvmName("lxslursshpoclowk")
    public suspend
    fun diskIopsConfiguration(`value`: Output<WindowsFileSystemDiskIopsConfigurationArgs>) {
        this.diskIopsConfiguration = value
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
     */
    @JvmName("hktjaneldapsnxfw")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
     */
    @JvmName("ekqfxvpybrfhsdwg")
    public suspend fun preferredSubnetId(`value`: Output<String>) {
        this.preferredSubnetId = value
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("ofpcsenggrfhliyi")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("icjtjouedoubxiba")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("bevuynupdmcxniis")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
     */
    @JvmName("lwkfvgsnitafpmpp")
    public suspend
    fun selfManagedActiveDirectory(`value`: Output<WindowsFileSystemSelfManagedActiveDirectoryArgs>) {
        this.selfManagedActiveDirectory = value
    }

    /**
     * @param value When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("paypadxgwfbxekxp")
    public suspend fun skipFinalBackup(`value`: Output<Boolean>) {
        this.skipFinalBackup = value
    }

    /**
     * @param value Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
     */
    @JvmName("avipgcnplhrjoxel")
    public suspend fun storageCapacity(`value`: Output<Int>) {
        this.storageCapacity = value
    }

    /**
     * @param value Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
     */
    @JvmName("hdxfkfwnfukhwqky")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
     */
    @JvmName("naaearvjiptrqcef")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("bfwkiltnxonywfpf")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
     */
    @JvmName("neyjwnrtthcvyeyn")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jkgbidwwjqnisgyo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
     * The following arguments are optional:
     */
    @JvmName("nsbbddvctndqjkko")
    public suspend fun throughputCapacity(`value`: Output<Int>) {
        this.throughputCapacity = value
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("loqhxtnltxksvale")
    public suspend fun weeklyMaintenanceStartTime(`value`: Output<String>) {
        this.weeklyMaintenanceStartTime = value
    }

    /**
     * @param value The ID for an existing Microsoft Active Directory instance that the file system should join when it's created. Cannot be specified with `self_managed_active_directory`.
     */
    @JvmName("uqffufftpuddnjya")
    public suspend fun activeDirectoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryId = mapped
    }

    /**
     * @param value An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
     */
    @JvmName("esrnospdkiieftdc")
    public suspend fun aliases(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param values An array DNS alias names that you want to associate with the Amazon FSx file system.  For more information, see [Working with DNS Aliases](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
     */
    @JvmName("pxoxeqgeumqdsrmx")
    public suspend fun aliases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliases = mapped
    }

    /**
     * @param value The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
     */
    @JvmName("jypdgspnhokyqhdf")
    public suspend fun auditLogConfiguration(`value`: WindowsFileSystemAuditLogConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditLogConfiguration = mapped
    }

    /**
     * @param argument The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. See Audit Log Configuration below.
     */
    @JvmName("djsskgatqunwyytl")
    public suspend
    fun auditLogConfiguration(argument: suspend WindowsFileSystemAuditLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsFileSystemAuditLogConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.auditLogConfiguration = mapped
    }

    /**
     * @param value The number of days to retain automatic backups. Minimum of `0` and maximum of `90`. Defaults to `7`. Set to `0` to disable.
     */
    @JvmName("mapbajpopjnjwirh")
    public suspend fun automaticBackupRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticBackupRetentionDays = mapped
    }

    /**
     * @param value The ID of the source backup to create the filesystem from.
     */
    @JvmName("jqhjkytkisadwtsm")
    public suspend fun backupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupId = mapped
    }

    /**
     * @param value A boolean flag indicating whether tags on the file system should be copied to backups. Defaults to `false`.
     */
    @JvmName("imuwdewvdtlgxtjk")
    public suspend fun copyTagsToBackups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToBackups = mapped
    }

    /**
     * @param value The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
     */
    @JvmName("bjklopvfecshuwnm")
    public suspend fun dailyAutomaticBackupStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyAutomaticBackupStartTime = mapped
    }

    /**
     * @param value Specifies the file system deployment type, valid values are `MULTI_AZ_1`, `SINGLE_AZ_1` and `SINGLE_AZ_2`. Default value is `SINGLE_AZ_1`.
     */
    @JvmName("mxsnwgkkwmtnnofn")
    public suspend fun deploymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
     */
    @JvmName("nlewmhmwvtfejocd")
    public suspend fun diskIopsConfiguration(`value`: WindowsFileSystemDiskIopsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIopsConfiguration = mapped
    }

    /**
     * @param argument The SSD IOPS configuration for the Amazon FSx for Windows File Server file system. See Disk Iops Configuration below.
     */
    @JvmName("nsulvudllwtscita")
    public suspend
    fun diskIopsConfiguration(argument: suspend WindowsFileSystemDiskIopsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsFileSystemDiskIopsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.diskIopsConfiguration = mapped
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest. Defaults to an AWS managed KMS Key.
     */
    @JvmName("lkemwehpyebilvch")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specifies the subnet in which you want the preferred file server to be located. Required for when deployment type is `MULTI_AZ_1`.
     */
    @JvmName("pjwqvydjnjuswbiv")
    public suspend fun preferredSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredSubnetId = mapped
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("edxfxoclwrdahihe")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("ngsyhiedtwehykhf")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
     */
    @JvmName("yqnxclhqrjlaolji")
    public suspend
    fun selfManagedActiveDirectory(`value`: WindowsFileSystemSelfManagedActiveDirectoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfManagedActiveDirectory = mapped
    }

    /**
     * @param argument Configuration block that Amazon FSx uses to join the Windows File Server instance to your self-managed (including on-premises) Microsoft Active Directory (AD) directory. Cannot be specified with `active_directory_id`. See Self-Managed Active Directory below.
     */
    @JvmName("sbfsbvwwihdcbvyo")
    public suspend
    fun selfManagedActiveDirectory(argument: suspend WindowsFileSystemSelfManagedActiveDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsFileSystemSelfManagedActiveDirectoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.selfManagedActiveDirectory = mapped
    }

    /**
     * @param value When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("jrehspcadsghdeji")
    public suspend fun skipFinalBackup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalBackup = mapped
    }

    /**
     * @param value Storage capacity (GiB) of the file system. Minimum of 32 and maximum of 65536. If the storage type is set to `HDD` the minimum value is 2000. Required when not creating filesystem for a backup.
     */
    @JvmName("icrcvevjllwdaacj")
    public suspend fun storageCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacity = mapped
    }

    /**
     * @param value Specifies the storage type, Valid values are `SSD` and `HDD`. `HDD` is supported on `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types. Default value is `SSD`.
     */
    @JvmName("enwlfstmtfvupblg")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
     */
    @JvmName("rwusxpelafpwdpbl")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of IDs for the subnets that the file system will be accessible from. To specify more than a single subnet set `deployment_type` to `MULTI_AZ_1`.
     */
    @JvmName("hshfpaahkjsjsgnd")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dxhmsvqxjhttrvjn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rxunealesasrrqla")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
     * The following arguments are optional:
     */
    @JvmName("eooqrqhxnpilwunr")
    public suspend fun throughputCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputCapacity = mapped
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("wqqvwmlkrxvgvbty")
    public suspend fun weeklyMaintenanceStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyMaintenanceStartTime = mapped
    }

    internal fun build(): WindowsFileSystemArgs = WindowsFileSystemArgs(
        activeDirectoryId = activeDirectoryId,
        aliases = aliases,
        auditLogConfiguration = auditLogConfiguration,
        automaticBackupRetentionDays = automaticBackupRetentionDays,
        backupId = backupId,
        copyTagsToBackups = copyTagsToBackups,
        dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime,
        deploymentType = deploymentType,
        diskIopsConfiguration = diskIopsConfiguration,
        kmsKeyId = kmsKeyId,
        preferredSubnetId = preferredSubnetId,
        securityGroupIds = securityGroupIds,
        selfManagedActiveDirectory = selfManagedActiveDirectory,
        skipFinalBackup = skipFinalBackup,
        storageCapacity = storageCapacity,
        storageType = storageType,
        subnetIds = subnetIds,
        tags = tags,
        throughputCapacity = throughputCapacity,
        weeklyMaintenanceStartTime = weeklyMaintenanceStartTime,
    )
}
