@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property autoExportPolicy Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
 * @property autoImportPolicy Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
 */
public data class DataRepositoryAssociationS3Args(
    public val autoExportPolicy: Output<DataRepositoryAssociationS3AutoExportPolicyArgs>? = null,
    public val autoImportPolicy: Output<DataRepositoryAssociationS3AutoImportPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3Args> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3Args =
        com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3Args.builder()
            .autoExportPolicy(autoExportPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .autoImportPolicy(
                autoImportPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataRepositoryAssociationS3Args].
 */
@PulumiTagMarker
public class DataRepositoryAssociationS3ArgsBuilder internal constructor() {
    private var autoExportPolicy: Output<DataRepositoryAssociationS3AutoExportPolicyArgs>? = null

    private var autoImportPolicy: Output<DataRepositoryAssociationS3AutoImportPolicyArgs>? = null

    /**
     * @param value Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
     */
    @JvmName("hvpivudoiittmjwa")
    public suspend
    fun autoExportPolicy(`value`: Output<DataRepositoryAssociationS3AutoExportPolicyArgs>) {
        this.autoExportPolicy = value
    }

    /**
     * @param value Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
     */
    @JvmName("qgbfdkiradhdufdt")
    public suspend
    fun autoImportPolicy(`value`: Output<DataRepositoryAssociationS3AutoImportPolicyArgs>) {
        this.autoImportPolicy = value
    }

    /**
     * @param value Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
     */
    @JvmName("dojawgeehtfjgewn")
    public suspend fun autoExportPolicy(`value`: DataRepositoryAssociationS3AutoExportPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoExportPolicy = mapped
    }

    /**
     * @param argument Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
     */
    @JvmName("dlrxtfghxiwdoqyp")
    public suspend
    fun autoExportPolicy(argument: suspend DataRepositoryAssociationS3AutoExportPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DataRepositoryAssociationS3AutoExportPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoExportPolicy = mapped
    }

    /**
     * @param value Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
     */
    @JvmName("gntrnmqeevxcsnsc")
    public suspend fun autoImportPolicy(`value`: DataRepositoryAssociationS3AutoImportPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoImportPolicy = mapped
    }

    /**
     * @param argument Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
     */
    @JvmName("jifwygypiquonasi")
    public suspend
    fun autoImportPolicy(argument: suspend DataRepositoryAssociationS3AutoImportPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DataRepositoryAssociationS3AutoImportPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoImportPolicy = mapped
    }

    internal fun build(): DataRepositoryAssociationS3Args = DataRepositoryAssociationS3Args(
        autoExportPolicy = autoExportPolicy,
        autoImportPolicy = autoImportPolicy,
    )
}
