@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property associationId
 * @property dataRepositoryPath The path to the S3 or NFS data repository that links to the cache.
 * @property dataRepositorySubdirectories A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
 * @property fileCacheId The system-generated, unique ID of the cache.
 * @property fileCachePath A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
 * @property fileSystemId
 * @property fileSystemPath
 * @property importedFileChunkSize
 * @property nfs (Optional) See the `nfs` configuration block.
 * @property resourceArn
 * @property tags A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FileCacheDataRepositoryAssociationArgs(
    public val associationId: Output<String>? = null,
    public val dataRepositoryPath: Output<String>,
    public val dataRepositorySubdirectories: Output<List<String>>? = null,
    public val fileCacheId: Output<String>? = null,
    public val fileCachePath: Output<String>,
    public val fileSystemId: Output<String>? = null,
    public val fileSystemPath: Output<String>? = null,
    public val importedFileChunkSize: Output<Int>? = null,
    public val nfs: Output<List<FileCacheDataRepositoryAssociationNfArgs>>? = null,
    public val resourceArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationArgs =
        com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationArgs.builder()
            .associationId(associationId?.applyValue({ args0 -> args0 }))
            .dataRepositoryPath(dataRepositoryPath.applyValue({ args0 -> args0 }))
            .dataRepositorySubdirectories(
                dataRepositorySubdirectories?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .fileCacheId(fileCacheId?.applyValue({ args0 -> args0 }))
            .fileCachePath(fileCachePath.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .fileSystemPath(fileSystemPath?.applyValue({ args0 -> args0 }))
            .importedFileChunkSize(importedFileChunkSize?.applyValue({ args0 -> args0 }))
            .nfs(nfs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FileCacheDataRepositoryAssociationArgs].
 */
@PulumiTagMarker
public class FileCacheDataRepositoryAssociationArgsBuilder internal constructor() {
    private var associationId: Output<String>? = null

    private var dataRepositoryPath: Output<String>? = null

    private var dataRepositorySubdirectories: Output<List<String>>? = null

    private var fileCacheId: Output<String>? = null

    private var fileCachePath: Output<String>? = null

    private var fileSystemId: Output<String>? = null

    private var fileSystemPath: Output<String>? = null

    private var importedFileChunkSize: Output<Int>? = null

    private var nfs: Output<List<FileCacheDataRepositoryAssociationNfArgs>>? = null

    private var resourceArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("vlfsubkkcliytecx")
    public suspend fun associationId(`value`: Output<String>) {
        this.associationId = value
    }

    /**
     * @param value The path to the S3 or NFS data repository that links to the cache.
     */
    @JvmName("iudjrgbcbwtcxoby")
    public suspend fun dataRepositoryPath(`value`: Output<String>) {
        this.dataRepositoryPath = value
    }

    /**
     * @param value A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
     */
    @JvmName("msxiwwqwnlsijlbn")
    public suspend fun dataRepositorySubdirectories(`value`: Output<List<String>>) {
        this.dataRepositorySubdirectories = value
    }

    @JvmName("hjhfkrkwcfrjwfeb")
    public suspend fun dataRepositorySubdirectories(vararg values: Output<String>) {
        this.dataRepositorySubdirectories = Output.all(values.asList())
    }

    /**
     * @param values A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
     */
    @JvmName("hhpdvmwwmptgwwly")
    public suspend fun dataRepositorySubdirectories(values: List<Output<String>>) {
        this.dataRepositorySubdirectories = Output.all(values)
    }

    /**
     * @param value The system-generated, unique ID of the cache.
     */
    @JvmName("yisdcpmoxloqnmvo")
    public suspend fun fileCacheId(`value`: Output<String>) {
        this.fileCacheId = value
    }

    /**
     * @param value A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
     */
    @JvmName("qecivlpargebddlt")
    public suspend fun fileCachePath(`value`: Output<String>) {
        this.fileCachePath = value
    }

    /**
     * @param value
     */
    @JvmName("mdfwkhrwyiojruva")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value
     */
    @JvmName("svfeuvkfvrhwybmf")
    public suspend fun fileSystemPath(`value`: Output<String>) {
        this.fileSystemPath = value
    }

    /**
     * @param value
     */
    @JvmName("dalxnfcyhelaikjk")
    public suspend fun importedFileChunkSize(`value`: Output<Int>) {
        this.importedFileChunkSize = value
    }

    /**
     * @param value (Optional) See the `nfs` configuration block.
     */
    @JvmName("sycebudgslrdhube")
    public suspend fun nfs(`value`: Output<List<FileCacheDataRepositoryAssociationNfArgs>>) {
        this.nfs = value
    }

    @JvmName("dgwjijgmqnxwtoda")
    public suspend fun nfs(vararg values: Output<FileCacheDataRepositoryAssociationNfArgs>) {
        this.nfs = Output.all(values.asList())
    }

    /**
     * @param values (Optional) See the `nfs` configuration block.
     */
    @JvmName("xgsfjsseiaijnndp")
    public suspend fun nfs(values: List<Output<FileCacheDataRepositoryAssociationNfArgs>>) {
        this.nfs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kjdcefgjsobvmxfx")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wjmahxdugwsweohc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("jaxndejlfumdjxgj")
    public suspend fun associationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associationId = mapped
    }

    /**
     * @param value The path to the S3 or NFS data repository that links to the cache.
     */
    @JvmName("pkctwuvgusvsehig")
    public suspend fun dataRepositoryPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataRepositoryPath = mapped
    }

    /**
     * @param value A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
     */
    @JvmName("iwnfwtjuxnpltoik")
    public suspend fun dataRepositorySubdirectories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRepositorySubdirectories = mapped
    }

    /**
     * @param values A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
     */
    @JvmName("duqoqiutvykjtuem")
    public suspend fun dataRepositorySubdirectories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataRepositorySubdirectories = mapped
    }

    /**
     * @param value The system-generated, unique ID of the cache.
     */
    @JvmName("rdrjgqqwbkujyimm")
    public suspend fun fileCacheId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileCacheId = mapped
    }

    /**
     * @param value A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
     */
    @JvmName("viqbxlhewvkonedw")
    public suspend fun fileCachePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileCachePath = mapped
    }

    /**
     * @param value
     */
    @JvmName("drajfeverfaktngx")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value
     */
    @JvmName("vdkacrplshakjcap")
    public suspend fun fileSystemPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemPath = mapped
    }

    /**
     * @param value
     */
    @JvmName("mbmxixhaouvxyppe")
    public suspend fun importedFileChunkSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importedFileChunkSize = mapped
    }

    /**
     * @param value (Optional) See the `nfs` configuration block.
     */
    @JvmName("hcqveojiscjvdfon")
    public suspend fun nfs(`value`: List<FileCacheDataRepositoryAssociationNfArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfs = mapped
    }

    /**
     * @param argument (Optional) See the `nfs` configuration block.
     */
    @JvmName("hgteysctdtadcvpm")
    public suspend
    fun nfs(argument: List<suspend FileCacheDataRepositoryAssociationNfArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileCacheDataRepositoryAssociationNfArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.nfs = mapped
    }

    /**
     * @param argument (Optional) See the `nfs` configuration block.
     */
    @JvmName("fkixerdlwkpsvmtx")
    public suspend fun nfs(
        vararg
        argument: suspend FileCacheDataRepositoryAssociationNfArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FileCacheDataRepositoryAssociationNfArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.nfs = mapped
    }

    /**
     * @param argument (Optional) See the `nfs` configuration block.
     */
    @JvmName("mxnaohldlfrtaslv")
    public suspend
    fun nfs(argument: suspend FileCacheDataRepositoryAssociationNfArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FileCacheDataRepositoryAssociationNfArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.nfs = mapped
    }

    /**
     * @param values (Optional) See the `nfs` configuration block.
     */
    @JvmName("nutcogrhsxchwbta")
    public suspend fun nfs(vararg values: FileCacheDataRepositoryAssociationNfArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nfs = mapped
    }

    /**
     * @param value
     */
    @JvmName("aqdkrmphobawvqel")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("klivctxjyxrroual")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kjjjwtsrwcyeaqlh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FileCacheDataRepositoryAssociationArgs =
        FileCacheDataRepositoryAssociationArgs(
            associationId = associationId,
            dataRepositoryPath = dataRepositoryPath ?: throw PulumiNullFieldException("dataRepositoryPath"),
            dataRepositorySubdirectories = dataRepositorySubdirectories,
            fileCacheId = fileCacheId,
            fileCachePath = fileCachePath ?: throw PulumiNullFieldException("fileCachePath"),
            fileSystemId = fileSystemId,
            fileSystemPath = fileSystemPath,
            importedFileChunkSize = importedFileChunkSize,
            nfs = nfs,
            resourceArn = resourceArn,
            tags = tags,
        )
}
