@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationNfArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dnsIps A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
 * @property version The version of the NFS (Network File System) protocol of the NFS data repository. The only supported value is NFS3, which indicates that the data repository must support the NFSv3 protocol. The only supported value is `NFS3`.
 */
public data class FileCacheDataRepositoryAssociationNfArgs(
    public val dnsIps: Output<List<String>>? = null,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationNfArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationNfArgs =
        com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationNfArgs.builder()
            .dnsIps(dnsIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileCacheDataRepositoryAssociationNfArgs].
 */
@PulumiTagMarker
public class FileCacheDataRepositoryAssociationNfArgsBuilder internal constructor() {
    private var dnsIps: Output<List<String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
     */
    @JvmName("irmotyenlhwcvogr")
    public suspend fun dnsIps(`value`: Output<List<String>>) {
        this.dnsIps = value
    }

    @JvmName("xrukknhqftxmctfq")
    public suspend fun dnsIps(vararg values: Output<String>) {
        this.dnsIps = Output.all(values.asList())
    }

    /**
     * @param values A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
     */
    @JvmName("mfgytksilyxormdr")
    public suspend fun dnsIps(values: List<Output<String>>) {
        this.dnsIps = Output.all(values)
    }

    /**
     * @param value The version of the NFS (Network File System) protocol of the NFS data repository. The only supported value is NFS3, which indicates that the data repository must support the NFSv3 protocol. The only supported value is `NFS3`.
     */
    @JvmName("imtxccocgypnlius")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
     */
    @JvmName("qwqpjscyvoimilfs")
    public suspend fun dnsIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsIps = mapped
    }

    /**
     * @param values A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
     */
    @JvmName("xpekcfrrovfalkji")
    public suspend fun dnsIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsIps = mapped
    }

    /**
     * @param value The version of the NFS (Network File System) protocol of the NFS data repository. The only supported value is NFS3, which indicates that the data repository must support the NFSv3 protocol. The only supported value is `NFS3`.
     */
    @JvmName("tuqnjbvoiyapsfwi")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): FileCacheDataRepositoryAssociationNfArgs =
        FileCacheDataRepositoryAssociationNfArgs(
            dnsIps = dnsIps,
            version = version ?: throw PulumiNullFieldException("version"),
        )
}
