@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationMetadataConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property storageCapacity The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only supported value is `2400` GiB.
 */
public data class FileCacheLustreConfigurationMetadataConfigurationArgs(
    public val storageCapacity: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationMetadataConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationMetadataConfigurationArgs =
        com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationMetadataConfigurationArgs.builder()
            .storageCapacity(storageCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileCacheLustreConfigurationMetadataConfigurationArgs].
 */
@PulumiTagMarker
public class FileCacheLustreConfigurationMetadataConfigurationArgsBuilder internal constructor() {
    private var storageCapacity: Output<Int>? = null

    /**
     * @param value The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only supported value is `2400` GiB.
     */
    @JvmName("uxolxoxpudjnkbov")
    public suspend fun storageCapacity(`value`: Output<Int>) {
        this.storageCapacity = value
    }

    /**
     * @param value The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only supported value is `2400` GiB.
     */
    @JvmName("ijhejsoyekorcmhj")
    public suspend fun storageCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageCapacity = mapped
    }

    internal fun build(): FileCacheLustreConfigurationMetadataConfigurationArgs =
        FileCacheLustreConfigurationMetadataConfigurationArgs(
            storageCapacity = storageCapacity ?: throw PulumiNullFieldException("storageCapacity"),
        )
}
