@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property auditLogVolume Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`.
 * @property autocommitPeriod The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See Autocommit Period below.
 * @property privilegedDelete Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Valid values: `DISABLED`, `ENABLED`, `PERMANENTLY_DISABLED`. The default value is `DISABLED`.
 * @property retentionPeriod The retention period of an FSx for ONTAP SnapLock volume. See SnapLock Retention Period below.
 * @property snaplockType Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Valid values: `COMPLIANCE`, `ENTERPRISE`.
 * @property volumeAppendModeEnabled Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. The default value is `false`.
 */
public data class OntapVolumeSnaplockConfigurationArgs(
    public val auditLogVolume: Output<Boolean>? = null,
    public val autocommitPeriod: Output<OntapVolumeSnaplockConfigurationAutocommitPeriodArgs>? = null,
    public val privilegedDelete: Output<String>? = null,
    public val retentionPeriod: Output<OntapVolumeSnaplockConfigurationRetentionPeriodArgs>? = null,
    public val snaplockType: Output<String>,
    public val volumeAppendModeEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationArgs =
        com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationArgs.builder()
            .auditLogVolume(auditLogVolume?.applyValue({ args0 -> args0 }))
            .autocommitPeriod(autocommitPeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privilegedDelete(privilegedDelete?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snaplockType(snaplockType.applyValue({ args0 -> args0 }))
            .volumeAppendModeEnabled(volumeAppendModeEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapVolumeSnaplockConfigurationArgs].
 */
@PulumiTagMarker
public class OntapVolumeSnaplockConfigurationArgsBuilder internal constructor() {
    private var auditLogVolume: Output<Boolean>? = null

    private var autocommitPeriod: Output<OntapVolumeSnaplockConfigurationAutocommitPeriodArgs>? = null

    private var privilegedDelete: Output<String>? = null

    private var retentionPeriod: Output<OntapVolumeSnaplockConfigurationRetentionPeriodArgs>? = null

    private var snaplockType: Output<String>? = null

    private var volumeAppendModeEnabled: Output<Boolean>? = null

    /**
     * @param value Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`.
     */
    @JvmName("cderyadmhmpqkonc")
    public suspend fun auditLogVolume(`value`: Output<Boolean>) {
        this.auditLogVolume = value
    }

    /**
     * @param value The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See Autocommit Period below.
     */
    @JvmName("iohqpdsewokuaadp")
    public suspend
    fun autocommitPeriod(`value`: Output<OntapVolumeSnaplockConfigurationAutocommitPeriodArgs>) {
        this.autocommitPeriod = value
    }

    /**
     * @param value Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Valid values: `DISABLED`, `ENABLED`, `PERMANENTLY_DISABLED`. The default value is `DISABLED`.
     */
    @JvmName("oggnlngxrpvvueix")
    public suspend fun privilegedDelete(`value`: Output<String>) {
        this.privilegedDelete = value
    }

    /**
     * @param value The retention period of an FSx for ONTAP SnapLock volume. See SnapLock Retention Period below.
     */
    @JvmName("jhmhjncbgesudeqr")
    public suspend
    fun retentionPeriod(`value`: Output<OntapVolumeSnaplockConfigurationRetentionPeriodArgs>) {
        this.retentionPeriod = value
    }

    /**
     * @param value Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Valid values: `COMPLIANCE`, `ENTERPRISE`.
     */
    @JvmName("xlpqfqfrckgwyfdj")
    public suspend fun snaplockType(`value`: Output<String>) {
        this.snaplockType = value
    }

    /**
     * @param value Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. The default value is `false`.
     */
    @JvmName("uakwoxnhemxtavdr")
    public suspend fun volumeAppendModeEnabled(`value`: Output<Boolean>) {
        this.volumeAppendModeEnabled = value
    }

    /**
     * @param value Enables or disables the audit log volume for an FSx for ONTAP SnapLock volume. The default value is `false`.
     */
    @JvmName("furvuuudnrpocrvd")
    public suspend fun auditLogVolume(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditLogVolume = mapped
    }

    /**
     * @param value The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See Autocommit Period below.
     */
    @JvmName("yhqhyvagiuwymlsn")
    public suspend
    fun autocommitPeriod(`value`: OntapVolumeSnaplockConfigurationAutocommitPeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autocommitPeriod = mapped
    }

    /**
     * @param argument The configuration object for setting the autocommit period of files in an FSx for ONTAP SnapLock volume. See Autocommit Period below.
     */
    @JvmName("nlrjycbyyqslfcpg")
    public suspend
    fun autocommitPeriod(argument: suspend OntapVolumeSnaplockConfigurationAutocommitPeriodArgsBuilder.() -> Unit) {
        val toBeMapped = OntapVolumeSnaplockConfigurationAutocommitPeriodArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autocommitPeriod = mapped
    }

    /**
     * @param value Enables, disables, or permanently disables privileged delete on an FSx for ONTAP SnapLock Enterprise volume. Valid values: `DISABLED`, `ENABLED`, `PERMANENTLY_DISABLED`. The default value is `DISABLED`.
     */
    @JvmName("ayulolwehdjcnbda")
    public suspend fun privilegedDelete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privilegedDelete = mapped
    }

    /**
     * @param value The retention period of an FSx for ONTAP SnapLock volume. See SnapLock Retention Period below.
     */
    @JvmName("chkjnaasmruxbwre")
    public suspend
    fun retentionPeriod(`value`: OntapVolumeSnaplockConfigurationRetentionPeriodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param argument The retention period of an FSx for ONTAP SnapLock volume. See SnapLock Retention Period below.
     */
    @JvmName("olawqcndoaemtcoo")
    public suspend
    fun retentionPeriod(argument: suspend OntapVolumeSnaplockConfigurationRetentionPeriodArgsBuilder.() -> Unit) {
        val toBeMapped = OntapVolumeSnaplockConfigurationRetentionPeriodArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.retentionPeriod = mapped
    }

    /**
     * @param value Specifies the retention mode of an FSx for ONTAP SnapLock volume. After it is set, it can't be changed. Valid values: `COMPLIANCE`, `ENTERPRISE`.
     */
    @JvmName("eltpweassqbxdemf")
    public suspend fun snaplockType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snaplockType = mapped
    }

    /**
     * @param value Enables or disables volume-append mode on an FSx for ONTAP SnapLock volume. The default value is `false`.
     */
    @JvmName("scpnqvmgsuctcdsy")
    public suspend fun volumeAppendModeEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeAppendModeEnabled = mapped
    }

    internal fun build(): OntapVolumeSnaplockConfigurationArgs = OntapVolumeSnaplockConfigurationArgs(
        auditLogVolume = auditLogVolume,
        autocommitPeriod = autocommitPeriod,
        privilegedDelete = privilegedDelete,
        retentionPeriod = retentionPeriod,
        snaplockType = snaplockType ?: throw PulumiNullFieldException("snaplockType"),
        volumeAppendModeEnabled = volumeAppendModeEnabled,
    )
}
