@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationAutocommitPeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
 * @property value The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
 */
public data class OntapVolumeSnaplockConfigurationAutocommitPeriodArgs(
    public val type: Output<String>? = null,
    public val `value`: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationAutocommitPeriodArgs> {
    override fun toJava():
        com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationAutocommitPeriodArgs =
        com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationAutocommitPeriodArgs.builder()
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapVolumeSnaplockConfigurationAutocommitPeriodArgs].
 */
@PulumiTagMarker
public class OntapVolumeSnaplockConfigurationAutocommitPeriodArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
     */
    @JvmName("rtrccxtkdblbawrg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
     */
    @JvmName("bjthmqrmfimajbba")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value The type of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume. Setting this value to `NONE` disables autocommit. Valid values: `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `NONE`.
     */
    @JvmName("moewhxakudaipxfy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
     */
    @JvmName("wxekduucenviwcwa")
    public suspend fun `value`(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): OntapVolumeSnaplockConfigurationAutocommitPeriodArgs =
        OntapVolumeSnaplockConfigurationAutocommitPeriodArgs(
            type = type,
            `value` = `value`,
        )
}
