@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OntapVolumeTieringPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property coolingPeriod Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with `AUTO` and `SNAPSHOT_ONLY` tiering policies only. Valid values are whole numbers between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
 * @property name Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
 */
public data class OntapVolumeTieringPolicyArgs(
    public val coolingPeriod: Output<Int>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.OntapVolumeTieringPolicyArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OntapVolumeTieringPolicyArgs =
        com.pulumi.aws.fsx.inputs.OntapVolumeTieringPolicyArgs.builder()
            .coolingPeriod(coolingPeriod?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapVolumeTieringPolicyArgs].
 */
@PulumiTagMarker
public class OntapVolumeTieringPolicyArgsBuilder internal constructor() {
    private var coolingPeriod: Output<Int>? = null

    private var name: Output<String>? = null

    /**
     * @param value Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with `AUTO` and `SNAPSHOT_ONLY` tiering policies only. Valid values are whole numbers between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
     */
    @JvmName("xubycbmxshwxyium")
    public suspend fun coolingPeriod(`value`: Output<Int>) {
        this.coolingPeriod = value
    }

    /**
     * @param value Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
     */
    @JvmName("dhyfhvwkimtfvgbk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with `AUTO` and `SNAPSHOT_ONLY` tiering policies only. Valid values are whole numbers between 2 and 183. Default values are 31 days for `AUTO` and 2 days for `SNAPSHOT_ONLY`.
     */
    @JvmName("lwetcdvnmdyesabj")
    public suspend fun coolingPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolingPeriod = mapped
    }

    /**
     * @param value Specifies the tiering policy for the ONTAP volume for moving data to the capacity pool storage. Valid values are `SNAPSHOT_ONLY`, `AUTO`, `ALL`, `NONE`. Default value is `SNAPSHOT_ONLY`.
     */
    @JvmName("fvnlgqrobppexdvs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): OntapVolumeTieringPolicyArgs = OntapVolumeTieringPolicyArgs(
        coolingPeriod = coolingPeriod,
        name = name,
    )
}
