@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OpenZfsVolumeOriginSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property copyStrategy
 * @property snapshotArn
 */
public data class OpenZfsVolumeOriginSnapshotArgs(
    public val copyStrategy: Output<String>,
    public val snapshotArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.OpenZfsVolumeOriginSnapshotArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OpenZfsVolumeOriginSnapshotArgs =
        com.pulumi.aws.fsx.inputs.OpenZfsVolumeOriginSnapshotArgs.builder()
            .copyStrategy(copyStrategy.applyValue({ args0 -> args0 }))
            .snapshotArn(snapshotArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenZfsVolumeOriginSnapshotArgs].
 */
@PulumiTagMarker
public class OpenZfsVolumeOriginSnapshotArgsBuilder internal constructor() {
    private var copyStrategy: Output<String>? = null

    private var snapshotArn: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("eyryfqghfmtoklbm")
    public suspend fun copyStrategy(`value`: Output<String>) {
        this.copyStrategy = value
    }

    /**
     * @param value
     */
    @JvmName("ntpepcosklooloss")
    public suspend fun snapshotArn(`value`: Output<String>) {
        this.snapshotArn = value
    }

    /**
     * @param value
     */
    @JvmName("cwnuxhvxusmrenbj")
    public suspend fun copyStrategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.copyStrategy = mapped
    }

    /**
     * @param value
     */
    @JvmName("bvkgqdfadebkhvxs")
    public suspend fun snapshotArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotArn = mapped
    }

    internal fun build(): OpenZfsVolumeOriginSnapshotArgs = OpenZfsVolumeOriginSnapshotArgs(
        copyStrategy = copyStrategy ?: throw PulumiNullFieldException("copyStrategy"),
        snapshotArn = snapshotArn ?: throw PulumiNullFieldException("snapshotArn"),
    )
}
