@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OpenZfsVolumeUserAndGroupQuotaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The ID of the user or group. Valid values between `0` and `2147483647`
 * @property storageCapacityQuotaGib The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
 * @property type
 */
public data class OpenZfsVolumeUserAndGroupQuotaArgs(
    public val id: Output<Int>,
    public val storageCapacityQuotaGib: Output<Int>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.OpenZfsVolumeUserAndGroupQuotaArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OpenZfsVolumeUserAndGroupQuotaArgs =
        com.pulumi.aws.fsx.inputs.OpenZfsVolumeUserAndGroupQuotaArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .storageCapacityQuotaGib(storageCapacityQuotaGib.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenZfsVolumeUserAndGroupQuotaArgs].
 */
@PulumiTagMarker
public class OpenZfsVolumeUserAndGroupQuotaArgsBuilder internal constructor() {
    private var id: Output<Int>? = null

    private var storageCapacityQuotaGib: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value The ID of the user or group. Valid values between `0` and `2147483647`
     */
    @JvmName("khgmmtvdwllynsby")
    public suspend fun id(`value`: Output<Int>) {
        this.id = value
    }

    /**
     * @param value The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
     */
    @JvmName("ujuyypduicyetboy")
    public suspend fun storageCapacityQuotaGib(`value`: Output<Int>) {
        this.storageCapacityQuotaGib = value
    }

    /**
     * @param value
     */
    @JvmName("kahddvyouorwwqgn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ID of the user or group. Valid values between `0` and `2147483647`
     */
    @JvmName("lwenmvbdogngcxtc")
    public suspend fun id(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
     */
    @JvmName("bsoigwpicltedonn")
    public suspend fun storageCapacityQuotaGib(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageCapacityQuotaGib = mapped
    }

    /**
     * @param value
     */
    @JvmName("dvijitdtitmhxbxf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OpenZfsVolumeUserAndGroupQuotaArgs = OpenZfsVolumeUserAndGroupQuotaArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        storageCapacityQuotaGib = storageCapacityQuotaGib ?: throw
            PulumiNullFieldException("storageCapacityQuotaGib"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
