@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.WindowsFileSystemAuditLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property auditLogDestination The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
 * @property fileAccessAuditLogLevel Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
 * @property fileShareAccessAuditLogLevel Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
 */
public data class WindowsFileSystemAuditLogConfigurationArgs(
    public val auditLogDestination: Output<String>? = null,
    public val fileAccessAuditLogLevel: Output<String>? = null,
    public val fileShareAccessAuditLogLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.WindowsFileSystemAuditLogConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.WindowsFileSystemAuditLogConfigurationArgs =
        com.pulumi.aws.fsx.inputs.WindowsFileSystemAuditLogConfigurationArgs.builder()
            .auditLogDestination(auditLogDestination?.applyValue({ args0 -> args0 }))
            .fileAccessAuditLogLevel(fileAccessAuditLogLevel?.applyValue({ args0 -> args0 }))
            .fileShareAccessAuditLogLevel(fileShareAccessAuditLogLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsFileSystemAuditLogConfigurationArgs].
 */
@PulumiTagMarker
public class WindowsFileSystemAuditLogConfigurationArgsBuilder internal constructor() {
    private var auditLogDestination: Output<String>? = null

    private var fileAccessAuditLogLevel: Output<String>? = null

    private var fileShareAccessAuditLogLevel: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
     */
    @JvmName("omoaiwtblsoskkty")
    public suspend fun auditLogDestination(`value`: Output<String>) {
        this.auditLogDestination = value
    }

    /**
     * @param value Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
     */
    @JvmName("gonrllwfmgxdyydr")
    public suspend fun fileAccessAuditLogLevel(`value`: Output<String>) {
        this.fileAccessAuditLogLevel = value
    }

    /**
     * @param value Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
     */
    @JvmName("iwodsrefscdsurpw")
    public suspend fun fileShareAccessAuditLogLevel(`value`: Output<String>) {
        this.fileShareAccessAuditLogLevel = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN. Can be specified when `file_access_audit_log_level` and `file_share_access_audit_log_level` are not set to `DISABLED`. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the `aws-fsx` prefix. If you do not provide a destination in `audit_log_destionation`, Amazon FSx will create and use a log stream in the CloudWatch Logs /aws/fsx/windows log group.
     */
    @JvmName("mtikvnrgjhbmpqji")
    public suspend fun auditLogDestination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditLogDestination = mapped
    }

    /**
     * @param value Sets which attempt type is logged by Amazon FSx for file and folder accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
     */
    @JvmName("hlqhdhlaruvbmkpc")
    public suspend fun fileAccessAuditLogLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileAccessAuditLogLevel = mapped
    }

    /**
     * @param value Sets which attempt type is logged by Amazon FSx for file share accesses. Valid values are `SUCCESS_ONLY`, `FAILURE_ONLY`, `SUCCESS_AND_FAILURE`, and `DISABLED`. Default value is `DISABLED`.
     */
    @JvmName("dvcgyllyxwrlndqh")
    public suspend fun fileShareAccessAuditLogLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileShareAccessAuditLogLevel = mapped
    }

    internal fun build(): WindowsFileSystemAuditLogConfigurationArgs =
        WindowsFileSystemAuditLogConfigurationArgs(
            auditLogDestination = auditLogDestination,
            fileAccessAuditLogLevel = fileAccessAuditLogLevel,
            fileShareAccessAuditLogLevel = fileShareAccessAuditLogLevel,
        )
}
