@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.WindowsFileSystemDiskIopsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property iops The total number of SSD IOPS provisioned for the file system.
 * @property mode Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
 */
public data class WindowsFileSystemDiskIopsConfigurationArgs(
    public val iops: Output<Int>? = null,
    public val mode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.WindowsFileSystemDiskIopsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.WindowsFileSystemDiskIopsConfigurationArgs =
        com.pulumi.aws.fsx.inputs.WindowsFileSystemDiskIopsConfigurationArgs.builder()
            .iops(iops?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsFileSystemDiskIopsConfigurationArgs].
 */
@PulumiTagMarker
public class WindowsFileSystemDiskIopsConfigurationArgsBuilder internal constructor() {
    private var iops: Output<Int>? = null

    private var mode: Output<String>? = null

    /**
     * @param value The total number of SSD IOPS provisioned for the file system.
     */
    @JvmName("hdqrpqtcfrosquot")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
     */
    @JvmName("qxwymrufmjpwvdch")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The total number of SSD IOPS provisioned for the file system.
     */
    @JvmName("wegyllcaxlaoiywg")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
     */
    @JvmName("ahkdnlqiuxhwqwvq")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): WindowsFileSystemDiskIopsConfigurationArgs =
        WindowsFileSystemDiskIopsConfigurationArgs(
            iops = iops,
            mode = mode,
        )
}
