@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property autoExportPolicy Specifies the type of updated objects that will be automatically exported from your file system to the linked S3 bucket. See the `events` configuration block.
 * @property autoImportPolicy Specifies the type of updated objects that will be automatically imported from the linked S3 bucket to your file system. See the `events` configuration block.
 */
public data class DataRepositoryAssociationS3(
    public val autoExportPolicy: DataRepositoryAssociationS3AutoExportPolicy? = null,
    public val autoImportPolicy: DataRepositoryAssociationS3AutoImportPolicy? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.DataRepositoryAssociationS3):
            DataRepositoryAssociationS3 = DataRepositoryAssociationS3(
            autoExportPolicy = javaType.autoExportPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.DataRepositoryAssociationS3AutoExportPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoImportPolicy = javaType.autoImportPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.DataRepositoryAssociationS3AutoImportPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
