@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property associationId
 * @property dataRepositoryPath The path to the S3 or NFS data repository that links to the cache.
 * @property dataRepositorySubdirectories A list of NFS Exports that will be linked with this data repository association. The Export paths are in the format /exportpath1. To use this parameter, you must configure DataRepositoryPath as the domain name of the NFS file system. The NFS file system domain name in effect is the root of the subdirectories. Note that DataRepositorySubdirectories is not supported for S3 data repositories. Max of 500.
 * @property fileCacheId The system-generated, unique ID of the cache.
 * @property fileCachePath A path on the cache that points to a high-level directory (such as /ns1/) or subdirectory (such as /ns1/subdir/) that will be mapped 1-1 with DataRepositoryPath. The leading forward slash in the name is required. Two data repository associations cannot have overlapping cache paths. For example, if a data repository is associated with cache path /ns1/, then you cannot link another data repository with cache path /ns1/ns2. This path specifies where in your cache files will be exported from. This cache directory can be linked to only one data repository, and no data repository other can be linked to the directory. Note: The cache path can only be set to root (/) on an NFS DRA when DataRepositorySubdirectories is specified. If you specify root (/) as the cache path, you can create only one DRA on the cache. The cache path cannot be set to root (/) for an S3 DRA.
 * @property fileSystemId
 * @property fileSystemPath
 * @property importedFileChunkSize
 * @property nfs (Optional) See the `nfs` configuration block.
 * @property resourceArn
 * @property tags A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FileCacheDataRepositoryAssociation(
    public val associationId: String? = null,
    public val dataRepositoryPath: String,
    public val dataRepositorySubdirectories: List<String>? = null,
    public val fileCacheId: String? = null,
    public val fileCachePath: String,
    public val fileSystemId: String? = null,
    public val fileSystemPath: String? = null,
    public val importedFileChunkSize: Int? = null,
    public val nfs: List<FileCacheDataRepositoryAssociationNf>? = null,
    public val resourceArn: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.FileCacheDataRepositoryAssociation):
            FileCacheDataRepositoryAssociation = FileCacheDataRepositoryAssociation(
            associationId = javaType.associationId().map({ args0 -> args0 }).orElse(null),
            dataRepositoryPath = javaType.dataRepositoryPath(),
            dataRepositorySubdirectories = javaType.dataRepositorySubdirectories().map({ args0 -> args0 }),
            fileCacheId = javaType.fileCacheId().map({ args0 -> args0 }).orElse(null),
            fileCachePath = javaType.fileCachePath(),
            fileSystemId = javaType.fileSystemId().map({ args0 -> args0 }).orElse(null),
            fileSystemPath = javaType.fileSystemPath().map({ args0 -> args0 }).orElse(null),
            importedFileChunkSize = javaType.importedFileChunkSize().map({ args0 -> args0 }).orElse(null),
            nfs = javaType.nfs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.FileCacheDataRepositoryAssociationNf.Companion.toKotlin(args0)
                })
            }),
            resourceArn = javaType.resourceArn().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
