@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property deploymentType Specifies the cache deployment type. The only supported value is `CACHE_1`.
 * @property logConfigurations
 * @property metadataConfigurations The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
 * @property mountName
 * @property perUnitStorageThroughput Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in MB/s/TiB. The only supported value is `1000`.
 * @property weeklyMaintenanceStartTime A recurring weekly time, in the format `D:HH:MM`. `D` is the day of the week, for which `1` represents Monday and `7` represents Sunday. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, 1:05:00 specifies maintenance at 5 AM Monday. See the [ISO week date](https://en.wikipedia.org/wiki/ISO_week_date) for more information.
 */
public data class FileCacheLustreConfiguration(
    public val deploymentType: String,
    public val logConfigurations: List<FileCacheLustreConfigurationLogConfiguration>? = null,
    public val metadataConfigurations: List<FileCacheLustreConfigurationMetadataConfiguration>,
    public val mountName: String? = null,
    public val perUnitStorageThroughput: Int,
    public val weeklyMaintenanceStartTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.FileCacheLustreConfiguration):
            FileCacheLustreConfiguration = FileCacheLustreConfiguration(
            deploymentType = javaType.deploymentType(),
            logConfigurations = javaType.logConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.FileCacheLustreConfigurationLogConfiguration.Companion.toKotlin(args0)
                })
            }),
            metadataConfigurations = javaType.metadataConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.FileCacheLustreConfigurationMetadataConfiguration.Companion.toKotlin(args0)
                })
            }),
            mountName = javaType.mountName().map({ args0 -> args0 }).orElse(null),
            perUnitStorageThroughput = javaType.perUnitStorageThroughput(),
            weeklyMaintenanceStartTime = javaType.weeklyMaintenanceStartTime().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
