@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property interclusters A FileSystemEndpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See FileSystemEndpoint below.
 * @property managements A FileSystemEndpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See FileSystemEndpoint below.
 */
public data class GetOntapFileSystemEndpoint(
    public val interclusters: List<GetOntapFileSystemEndpointIntercluster>,
    public val managements: List<GetOntapFileSystemEndpointManagement>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapFileSystemEndpoint):
            GetOntapFileSystemEndpoint = GetOntapFileSystemEndpoint(
            interclusters = javaType.interclusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapFileSystemEndpointIntercluster.Companion.toKotlin(args0)
                })
            }),
            managements = javaType.managements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapFileSystemEndpointManagement.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
