@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsName DNS name for the file system (e.g. `fs-12345678.corp.example.com`).
 * @property ipAddresses
 */
public data class GetOntapFileSystemEndpointIntercluster(
    public val dnsName: String,
    public val ipAddresses: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapFileSystemEndpointIntercluster):
            GetOntapFileSystemEndpointIntercluster = GetOntapFileSystemEndpointIntercluster(
            dnsName = javaType.dnsName(),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
        )
    }
}
