@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsIps A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
 * @property domainName The fully qualified domain name of the self-managed AD directory.
 * @property fileSystemAdministratorsGroup The name of the domain group whose members have administrative privileges for the FSx file system.
 * @property organizationalUnitDistinguishedName The fully qualified distinguished name of the organizational unit within the self-managed AD directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.
 * @property username The user name for the service account on your self-managed AD domain that FSx uses to join to your AD domain.
 */
public data class
GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration(
    public val dnsIps: List<String>,
    public val domainName: String,
    public val fileSystemAdministratorsGroup: String,
    public val organizationalUnitDistinguishedName: String,
    public val username: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration):
            GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration =
            GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration(
                dnsIps = javaType.dnsIps().map({ args0 -> args0 }),
                domainName = javaType.domainName(),
                fileSystemAdministratorsGroup = javaType.fileSystemAdministratorsGroup(),
                organizationalUnitDistinguishedName = javaType.organizationalUnitDistinguishedName(),
                username = javaType.username(),
            )
    }
}
