@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property iscsis
 * @property managements An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager. See SVM Endpoint below.
 * @property nfs An endpoint for connecting using the Network File System (NFS) protocol. See SVM Endpoint below.
 * @property smbs An endpoint for connecting using the Server Message Block (SMB) protocol. See SVM Endpoint below.
 */
public data class GetOntapStorageVirtualMachineEndpoint(
    public val iscsis: List<GetOntapStorageVirtualMachineEndpointIscsi>,
    public val managements: List<GetOntapStorageVirtualMachineEndpointManagement>,
    public val nfs: List<GetOntapStorageVirtualMachineEndpointNf>,
    public val smbs: List<GetOntapStorageVirtualMachineEndpointSmb>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapStorageVirtualMachineEndpoint):
            GetOntapStorageVirtualMachineEndpoint = GetOntapStorageVirtualMachineEndpoint(
            iscsis = javaType.iscsis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineEndpointIscsi.Companion.toKotlin(args0)
                })
            }),
            managements = javaType.managements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineEndpointManagement.Companion.toKotlin(args0)
                })
            }),
            nfs = javaType.nfs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineEndpointNf.Companion.toKotlin(args0)
                })
            }),
            smbs = javaType.smbs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineEndpointSmb.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
