@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getOntapStorageVirtualMachine.
 * @property activeDirectoryConfigurations The Microsoft Active Directory configuration to which the SVM is joined, if applicable. See Active Directory Configuration below.
 * @property arn Amazon Resource Name of the SVM.
 * @property creationTime The time that the SVM was created.
 * @property endpoints The endpoints that are used to access data or to manage the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They are the Iscsi, Management, Nfs, and Smb endpoints. See SVM Endpoints below.
 * @property fileSystemId Identifier of the file system (e.g. `fs-12345678`).
 * @property filters
 * @property id The SVM's system generated unique ID.
 * @property lifecycleStatus The SVM's lifecycle status.
 * @property lifecycleTransitionReasons Describes why the SVM lifecycle state changed. See Lifecycle Transition Reason below.
 * @property name The name of the SVM, if provisioned.
 * @property subtype The SVM's subtype.
 * @property tags
 * @property uuid The SVM's UUID.
 */
public data class GetOntapStorageVirtualMachineResult(
    public val activeDirectoryConfigurations:
    List<GetOntapStorageVirtualMachineActiveDirectoryConfiguration>,
    public val arn: String,
    public val creationTime: String,
    public val endpoints: List<GetOntapStorageVirtualMachineEndpoint>,
    public val fileSystemId: String,
    public val filters: List<GetOntapStorageVirtualMachineFilter>? = null,
    public val id: String,
    public val lifecycleStatus: String,
    public val lifecycleTransitionReasons:
    List<GetOntapStorageVirtualMachineLifecycleTransitionReason>,
    public val name: String,
    public val subtype: String,
    public val tags: Map<String, String>,
    public val uuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapStorageVirtualMachineResult):
            GetOntapStorageVirtualMachineResult = GetOntapStorageVirtualMachineResult(
            activeDirectoryConfigurations = javaType.activeDirectoryConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineActiveDirectoryConfiguration.Companion.toKotlin(args0)
                })
            }),
            arn = javaType.arn(),
            creationTime = javaType.creationTime(),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineEndpoint.Companion.toKotlin(args0)
                })
            }),
            fileSystemId = javaType.fileSystemId(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            lifecycleStatus = javaType.lifecycleStatus(),
            lifecycleTransitionReasons = javaType.lifecycleTransitionReasons().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineLifecycleTransitionReason.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            subtype = javaType.subtype(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            uuid = javaType.uuid(),
        )
    }
}
