@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOntapStorageVirtualMachines.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids List of all SVM IDs found.
 */
public data class GetOntapStorageVirtualMachinesResult(
    public val filters: List<GetOntapStorageVirtualMachinesFilter>? = null,
    public val id: String,
    public val ids: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapStorageVirtualMachinesResult):
            GetOntapStorageVirtualMachinesResult = GetOntapStorageVirtualMachinesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachinesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
        )
    }
}
