@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getWindowsFileSystem.
 * @property activeDirectoryId The ID for Microsoft Active Directory instance that the file system is join to.
 * @property aliases An array DNS alias names associated with the Amazon FSx file system.
 * @property arn Amazon Resource Name of the file system.
 * @property auditLogConfigurations The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.
 * @property automaticBackupRetentionDays The number of days to retain automatic backups.
 * @property backupId
 * @property copyTagsToBackups A boolean flag indicating whether tags on the file system should be copied to backups.
 * @property dailyAutomaticBackupStartTime The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
 * @property deploymentType The file system deployment type.
 * @property diskIopsConfigurations The SSD IOPS configuration for the file system.
 * @property dnsName DNS name for the file system (e.g. `fs-12345678.corp.example.com`).
 * @property id Identifier of the file system (e.g. `fs-12345678`).
 * @property kmsKeyId ARN for the KMS Key to encrypt the file system at rest.
 * @property networkInterfaceIds
 * @property ownerId AWS account identifier that created the file system.
 * @property preferredFileServerIp The IP address of the primary, or preferred, file server.
 * @property preferredSubnetId Specifies the subnet in which you want the preferred file server to be located.
 * @property securityGroupIds
 * @property skipFinalBackup
 * @property storageCapacity The storage capacity of the file system in gibibytes (GiB).
 * @property storageType The type of storage the file system is using. If set to `SSD`, the file system uses solid state drive storage. If set to `HDD`, the file system uses hard disk drive storage.
 * @property subnetIds Specifies the IDs of the subnets that the file system is accessible from.
 * @property tags The tags to associate with the file system.
 * @property throughputCapacity Throughput (megabytes per second) of the file system in power of 2 increments. Minimum of `8` and maximum of `2048`.
 * @property vpcId The ID of the primary virtual private cloud (VPC) for the file system.
 * @property weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
 */
public data class GetWindowsFileSystemResult(
    public val activeDirectoryId: String,
    public val aliases: List<String>,
    public val arn: String,
    public val auditLogConfigurations: List<GetWindowsFileSystemAuditLogConfiguration>,
    public val automaticBackupRetentionDays: Int,
    public val backupId: String,
    public val copyTagsToBackups: Boolean,
    public val dailyAutomaticBackupStartTime: String,
    public val deploymentType: String,
    public val diskIopsConfigurations: List<GetWindowsFileSystemDiskIopsConfiguration>,
    public val dnsName: String,
    public val id: String,
    public val kmsKeyId: String,
    public val networkInterfaceIds: List<String>,
    public val ownerId: String,
    public val preferredFileServerIp: String,
    public val preferredSubnetId: String,
    public val securityGroupIds: List<String>,
    public val skipFinalBackup: Boolean,
    public val storageCapacity: Int,
    public val storageType: String,
    public val subnetIds: List<String>,
    public val tags: Map<String, String>,
    public val throughputCapacity: Int,
    public val vpcId: String,
    public val weeklyMaintenanceStartTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetWindowsFileSystemResult):
            GetWindowsFileSystemResult = GetWindowsFileSystemResult(
            activeDirectoryId = javaType.activeDirectoryId(),
            aliases = javaType.aliases().map({ args0 -> args0 }),
            arn = javaType.arn(),
            auditLogConfigurations = javaType.auditLogConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetWindowsFileSystemAuditLogConfiguration.Companion.toKotlin(args0)
                })
            }),
            automaticBackupRetentionDays = javaType.automaticBackupRetentionDays(),
            backupId = javaType.backupId(),
            copyTagsToBackups = javaType.copyTagsToBackups(),
            dailyAutomaticBackupStartTime = javaType.dailyAutomaticBackupStartTime(),
            deploymentType = javaType.deploymentType(),
            diskIopsConfigurations = javaType.diskIopsConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetWindowsFileSystemDiskIopsConfiguration.Companion.toKotlin(args0)
                })
            }),
            dnsName = javaType.dnsName(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            networkInterfaceIds = javaType.networkInterfaceIds().map({ args0 -> args0 }),
            ownerId = javaType.ownerId(),
            preferredFileServerIp = javaType.preferredFileServerIp(),
            preferredSubnetId = javaType.preferredSubnetId(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            skipFinalBackup = javaType.skipFinalBackup(),
            storageCapacity = javaType.storageCapacity(),
            storageType = javaType.storageType(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            throughputCapacity = javaType.throughputCapacity(),
            vpcId = javaType.vpcId(),
            weeklyMaintenanceStartTime = javaType.weeklyMaintenanceStartTime(),
        )
    }
}
