@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destination The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
 * @property level Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
 */
public data class LustreFileSystemLogConfiguration(
    public val destination: String? = null,
    public val level: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.LustreFileSystemLogConfiguration):
            LustreFileSystemLogConfiguration = LustreFileSystemLogConfiguration(
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
        )
    }
}
