@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property iops The total number of SSD IOPS provisioned for the file system.
 * @property mode Specifies whether the number of IOPS for the file system is using the system. Valid values are `AUTOMATIC` and `USER_PROVISIONED`. Default value is `AUTOMATIC`.
 */
public data class OntapFileSystemDiskIopsConfiguration(
    public val iops: Int? = null,
    public val mode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapFileSystemDiskIopsConfiguration):
            OntapFileSystemDiskIopsConfiguration = OntapFileSystemDiskIopsConfiguration(
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
