@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsName The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
 * @property ipAddresses IP addresses of the file system endpoint.
 */
public data class OntapFileSystemEndpointIntercluster(
    public val dnsName: String? = null,
    public val ipAddresses: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapFileSystemEndpointIntercluster):
            OntapFileSystemEndpointIntercluster = OntapFileSystemEndpointIntercluster(
            dnsName = javaType.dnsName().map({ args0 -> args0 }).orElse(null),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
        )
    }
}
