@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsIps A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.
 * @property domainName The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
 * @property fileSystemAdministratorsGroup The name of the domain group whose members are granted administrative privileges for the SVM. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
 * @property organizationalUnitDistinguishedName The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the SVM. If none is provided, the SVM is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
 * @property password The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
 * @property username The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
 */
public data class
OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration(
    public val dnsIps: List<String>,
    public val domainName: String,
    public val fileSystemAdministratorsGroup: String? = null,
    public val organizationalUnitDistinguishedName: String? = null,
    public val password: String,
    public val username: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration):
            OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration =
            OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration(
                dnsIps = javaType.dnsIps().map({ args0 -> args0 }),
                domainName = javaType.domainName(),
                fileSystemAdministratorsGroup = javaType.fileSystemAdministratorsGroup().map({ args0 ->
                    args0
                }).orElse(null),
                organizationalUnitDistinguishedName = javaType.organizationalUnitDistinguishedName().map({ args0 ->
                    args0
                }).orElse(null),
                password = javaType.password(),
                username = javaType.username(),
            )
    }
}
