@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property copyTagsToSnapshots A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
 * @property dataCompressionType Method used to compress the data on the volume. Valid values are `LZ4`, `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
 * @property nfsExports NFS export configuration for the root volume. Exactly 1 item. See NFS Exports Below.
 * @property readOnly specifies whether the volume is read-only. Default is false.
 * @property recordSizeKib Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
 * @property userAndGroupQuotas Specify how much storage users or groups can use on the volume. Maximum of 100 items. See User and Group Quotas Below.
 */
public data class OpenZfsFileSystemRootVolumeConfiguration(
    public val copyTagsToSnapshots: Boolean? = null,
    public val dataCompressionType: String? = null,
    public val nfsExports: OpenZfsFileSystemRootVolumeConfigurationNfsExports? = null,
    public val readOnly: Boolean? = null,
    public val recordSizeKib: Int? = null,
    public val userAndGroupQuotas: List<OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota>? =
        null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OpenZfsFileSystemRootVolumeConfiguration):
            OpenZfsFileSystemRootVolumeConfiguration = OpenZfsFileSystemRootVolumeConfiguration(
            copyTagsToSnapshots = javaType.copyTagsToSnapshots().map({ args0 -> args0 }).orElse(null),
            dataCompressionType = javaType.dataCompressionType().map({ args0 -> args0 }).orElse(null),
            nfsExports = javaType.nfsExports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OpenZfsFileSystemRootVolumeConfigurationNfsExports.Companion.toKotlin(args0)
                })
            }).orElse(null),
            readOnly = javaType.readOnly().map({ args0 -> args0 }).orElse(null),
            recordSizeKib = javaType.recordSizeKib().map({ args0 -> args0 }).orElse(null),
            userAndGroupQuotas = javaType.userAndGroupQuotas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuota.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
