@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the user or group. Valid values between `0` and `2147483647`
 * @property storageCapacityQuotaGib The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
 * @property type
 */
public data class OpenZfsVolumeUserAndGroupQuota(
    public val id: Int,
    public val storageCapacityQuotaGib: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OpenZfsVolumeUserAndGroupQuota):
            OpenZfsVolumeUserAndGroupQuota = OpenZfsVolumeUserAndGroupQuota(
            id = javaType.id(),
            storageCapacityQuotaGib = javaType.storageCapacityQuotaGib(),
            type = javaType.type(),
        )
    }
}
