@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.BuildArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.BuildStorageLocationArgs
import com.pulumi.aws.gamelift.kotlin.inputs.BuildStorageLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an GameLift Build resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Build;
 * import com.pulumi.aws.gamelift.BuildArgs;
 * import com.pulumi.aws.gamelift.inputs.BuildStorageLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Build("test", BuildArgs.builder()
 *             .operatingSystem("WINDOWS_2012")
 *             .storageLocation(BuildStorageLocationArgs.builder()
 *                 .bucket(aws_s3_bucket.test().id())
 *                 .key(aws_s3_object.test().key())
 *                 .roleArn(aws_iam_role.test().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GameLift Builds using the ID. For example:
 * ```sh
 *  $ pulumi import aws:gamelift/build:Build example <build-id>
 * ```
 * @property name Name of the build
 * @property operatingSystem Operating system that the game server binaries are built to run on. Valid values: `WINDOWS_2012`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `WINDOWS_2016`, `AMAZON_LINUX_2023`.
 * @property storageLocation Information indicating where your game build files are stored. See below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property version Version that is associated with this build.
 */
public data class BuildArgs(
    public val name: Output<String>? = null,
    public val operatingSystem: Output<String>? = null,
    public val storageLocation: Output<BuildStorageLocationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.BuildArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.BuildArgs =
        com.pulumi.aws.gamelift.BuildArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .operatingSystem(operatingSystem?.applyValue({ args0 -> args0 }))
            .storageLocation(storageLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildArgs].
 */
@PulumiTagMarker
public class BuildArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var operatingSystem: Output<String>? = null

    private var storageLocation: Output<BuildStorageLocationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Name of the build
     */
    @JvmName("uxvgphvyntvknhqd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Operating system that the game server binaries are built to run on. Valid values: `WINDOWS_2012`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `WINDOWS_2016`, `AMAZON_LINUX_2023`.
     */
    @JvmName("efqprdslxwfjerxm")
    public suspend fun operatingSystem(`value`: Output<String>) {
        this.operatingSystem = value
    }

    /**
     * @param value Information indicating where your game build files are stored. See below.
     */
    @JvmName("abnwhjvdcowctrwd")
    public suspend fun storageLocation(`value`: Output<BuildStorageLocationArgs>) {
        this.storageLocation = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqhvfniojueuxmik")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Version that is associated with this build.
     */
    @JvmName("hckcpnsxkxfwelao")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of the build
     */
    @JvmName("jqdoprhummlgypni")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Operating system that the game server binaries are built to run on. Valid values: `WINDOWS_2012`, `AMAZON_LINUX`, `AMAZON_LINUX_2`, `WINDOWS_2016`, `AMAZON_LINUX_2023`.
     */
    @JvmName("ogllfmoqvpfcswql")
    public suspend fun operatingSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operatingSystem = mapped
    }

    /**
     * @param value Information indicating where your game build files are stored. See below.
     */
    @JvmName("ylfcexpypcxvhytk")
    public suspend fun storageLocation(`value`: BuildStorageLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLocation = mapped
    }

    /**
     * @param argument Information indicating where your game build files are stored. See below.
     */
    @JvmName("kqolsjfswufqvgbe")
    public suspend fun storageLocation(argument: suspend BuildStorageLocationArgsBuilder.() -> Unit) {
        val toBeMapped = BuildStorageLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageLocation = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fkbgeragjiuxgjva")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dcuvmrjojohqbgnt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Version that is associated with this build.
     */
    @JvmName("niuuavbmjmvghfhh")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): BuildArgs = BuildArgs(
        name = name,
        operatingSystem = operatingSystem,
        storageLocation = storageLocation,
        tags = tags,
        version = version,
    )
}
