@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupAutoScalingPolicy
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupInstanceDefinition
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupLaunchTemplate
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupAutoScalingPolicy.Companion.toKotlin as gameServerGroupAutoScalingPolicyToKotlin
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupInstanceDefinition.Companion.toKotlin as gameServerGroupInstanceDefinitionToKotlin
import com.pulumi.aws.gamelift.kotlin.outputs.GameServerGroupLaunchTemplate.Companion.toKotlin as gameServerGroupLaunchTemplateToKotlin

/**
 * Builder for [GameServerGroup].
 */
@PulumiTagMarker
public class GameServerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GameServerGroupArgs = GameServerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GameServerGroupArgsBuilder.() -> Unit) {
        val builder = GameServerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GameServerGroup {
        val builtJavaResource = com.pulumi.aws.gamelift.GameServerGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GameServerGroup(builtJavaResource)
    }
}

/**
 * Provides an GameLift Game Server Group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameServerGroup;
 * import com.pulumi.aws.gamelift.GameServerGroupArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GameServerGroup("example", GameServerGroupArgs.builder()
 *             .gameServerGroupName("example")
 *             .instanceDefinitions(
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5.large")
 *                     .build(),
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5a.large")
 *                     .build())
 *             .launchTemplate(GameServerGroupLaunchTemplateArgs.builder()
 *                 .id(aws_launch_template.example().id())
 *                 .build())
 *             .maxSize(1)
 *             .minSize(1)
 *             .roleArn(aws_iam_role.example().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy_attachment.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Example IAM Role for GameLift Game Server Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getPartition();
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers(
 *                         "autoscaling.amazonaws.com",
 *                         "gamelift.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn(String.format("arn:%s:iam::aws:policy/GameLiftGameServerGroupPolicy", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .role(exampleRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GameLift Game Server Group using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:gamelift/gameServerGroup:GameServerGroup example example
 * ```
 *
 */
public class GameServerGroup internal constructor(
    override val javaResource: com.pulumi.aws.gamelift.GameServerGroup,
) : KotlinCustomResource(javaResource, GameServerGroupMapper) {
    /**
     * The ARN of the GameLift Game Server Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the created EC2 Auto Scaling group.
     */
    public val autoScalingGroupArn: Output<String>
        get() = javaResource.autoScalingGroupArn().applyValue({ args0 -> args0 })

    public val autoScalingPolicy: Output<GameServerGroupAutoScalingPolicy>?
        get() = javaResource.autoScalingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gameServerGroupAutoScalingPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
     * Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
     */
    public val balancingStrategy: Output<String>
        get() = javaResource.balancingStrategy().applyValue({ args0 -> args0 })

    /**
     * Name of the game server group.
     * This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
     */
    public val gameServerGroupName: Output<String>
        get() = javaResource.gameServerGroupName().applyValue({ args0 -> args0 })

    /**
     * Indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game.
     * Protected instances cannot be terminated while there are active game servers running except in the event
     * of a forced game server group deletion.
     * Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
     */
    public val gameServerProtectionPolicy: Output<String>
        get() = javaResource.gameServerProtectionPolicy().applyValue({ args0 -> args0 })

    public val instanceDefinitions: Output<List<GameServerGroupInstanceDefinition>>
        get() = javaResource.instanceDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> gameServerGroupInstanceDefinitionToKotlin(args0) })
            })
        })

    public val launchTemplate: Output<GameServerGroupLaunchTemplate>
        get() = javaResource.launchTemplate().applyValue({ args0 ->
            args0.let({ args0 ->
                gameServerGroupLaunchTemplateToKotlin(args0)
            })
        })

    /**
     * The maximum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
     */
    public val maxSize: Output<Int>
        get() = javaResource.maxSize().applyValue({ args0 -> args0 })

    /**
     * The minimum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
     */
    public val minSize: Output<Int>
        get() = javaResource.minSize().applyValue({ args0 -> args0 })

    /**
     * ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    public val vpcSubnets: Output<List<String>>?
        get() = javaResource.vpcSubnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object GameServerGroupMapper : ResourceMapper<GameServerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.gamelift.GameServerGroup::class == javaResource::class

    override fun map(javaResource: Resource): GameServerGroup = GameServerGroup(
        javaResource as
            com.pulumi.aws.gamelift.GameServerGroup,
    )
}

/**
 * @see [GameServerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GameServerGroup].
 */
public suspend fun gameServerGroup(
    name: String,
    block: suspend GameServerGroupResourceBuilder.() -> Unit,
): GameServerGroup {
    val builder = GameServerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GameServerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gameServerGroup(name: String): GameServerGroup {
    val builder = GameServerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
