@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.GameServerGroupArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupAutoScalingPolicyArgs
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupAutoScalingPolicyArgsBuilder
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupInstanceDefinitionArgs
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupInstanceDefinitionArgsBuilder
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupLaunchTemplateArgs
import com.pulumi.aws.gamelift.kotlin.inputs.GameServerGroupLaunchTemplateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an GameLift Game Server Group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameServerGroup;
 * import com.pulumi.aws.gamelift.GameServerGroupArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupInstanceDefinitionArgs;
 * import com.pulumi.aws.gamelift.inputs.GameServerGroupLaunchTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GameServerGroup("example", GameServerGroupArgs.builder()
 *             .gameServerGroupName("example")
 *             .instanceDefinitions(
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5.large")
 *                     .build(),
 *                 GameServerGroupInstanceDefinitionArgs.builder()
 *                     .instanceType("c5a.large")
 *                     .build())
 *             .launchTemplate(GameServerGroupLaunchTemplateArgs.builder()
 *                 .id(aws_launch_template.example().id())
 *                 .build())
 *             .maxSize(1)
 *             .minSize(1)
 *             .roleArn(aws_iam_role.example().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy_attachment.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Example IAM Role for GameLift Game Server Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getPartition();
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers(
 *                         "autoscaling.amazonaws.com",
 *                         "gamelift.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .policyArn(String.format("arn:%s:iam::aws:policy/GameLiftGameServerGroupPolicy", current.applyValue(getPartitionResult -> getPartitionResult.partition())))
 *             .role(exampleRole.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GameLift Game Server Group using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:gamelift/gameServerGroup:GameServerGroup example example
 * ```
 * @property autoScalingPolicy
 * @property balancingStrategy Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
 * Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
 * @property gameServerGroupName Name of the game server group.
 * This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
 * @property gameServerProtectionPolicy Indicates whether instances in the game server group are protected from early termination.
 * Unprotected instances that have active game servers running might be terminated during a scale-down event,
 * causing players to be dropped from the game.
 * Protected instances cannot be terminated while there are active game servers running except in the event
 * of a forced game server group deletion.
 * Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
 * @property instanceDefinitions
 * @property launchTemplate
 * @property maxSize The maximum number of instances allowed in the EC2 Auto Scaling group.
 * During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
 * @property minSize The minimum number of instances allowed in the EC2 Auto Scaling group.
 * During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
 * @property roleArn ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
 * @property tags Key-value map of resource tags
 * @property vpcSubnets A list of VPC subnets to use with instances in the game server group.
 * By default, all GameLift FleetIQ-supported Availability Zones are used.
 */
public data class GameServerGroupArgs(
    public val autoScalingPolicy: Output<GameServerGroupAutoScalingPolicyArgs>? = null,
    public val balancingStrategy: Output<String>? = null,
    public val gameServerGroupName: Output<String>? = null,
    public val gameServerProtectionPolicy: Output<String>? = null,
    public val instanceDefinitions: Output<List<GameServerGroupInstanceDefinitionArgs>>? = null,
    public val launchTemplate: Output<GameServerGroupLaunchTemplateArgs>? = null,
    public val maxSize: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSubnets: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.GameServerGroupArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.GameServerGroupArgs =
        com.pulumi.aws.gamelift.GameServerGroupArgs.builder()
            .autoScalingPolicy(autoScalingPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .balancingStrategy(balancingStrategy?.applyValue({ args0 -> args0 }))
            .gameServerGroupName(gameServerGroupName?.applyValue({ args0 -> args0 }))
            .gameServerProtectionPolicy(gameServerProtectionPolicy?.applyValue({ args0 -> args0 }))
            .instanceDefinitions(
                instanceDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchTemplate(launchTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcSubnets(vpcSubnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GameServerGroupArgs].
 */
@PulumiTagMarker
public class GameServerGroupArgsBuilder internal constructor() {
    private var autoScalingPolicy: Output<GameServerGroupAutoScalingPolicyArgs>? = null

    private var balancingStrategy: Output<String>? = null

    private var gameServerGroupName: Output<String>? = null

    private var gameServerProtectionPolicy: Output<String>? = null

    private var instanceDefinitions: Output<List<GameServerGroupInstanceDefinitionArgs>>? = null

    private var launchTemplate: Output<GameServerGroupLaunchTemplateArgs>? = null

    private var maxSize: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSubnets: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("xwuwsnthjunrueht")
    public suspend fun autoScalingPolicy(`value`: Output<GameServerGroupAutoScalingPolicyArgs>) {
        this.autoScalingPolicy = value
    }

    /**
     * @param value Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
     * Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
     */
    @JvmName("biwrpmegetuywysa")
    public suspend fun balancingStrategy(`value`: Output<String>) {
        this.balancingStrategy = value
    }

    /**
     * @param value Name of the game server group.
     * This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
     */
    @JvmName("htluywbpbutqwdvo")
    public suspend fun gameServerGroupName(`value`: Output<String>) {
        this.gameServerGroupName = value
    }

    /**
     * @param value Indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game.
     * Protected instances cannot be terminated while there are active game servers running except in the event
     * of a forced game server group deletion.
     * Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
     */
    @JvmName("kjfpjjttuotrbctu")
    public suspend fun gameServerProtectionPolicy(`value`: Output<String>) {
        this.gameServerProtectionPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("sxffkqoraujcnoah")
    public suspend
    fun instanceDefinitions(`value`: Output<List<GameServerGroupInstanceDefinitionArgs>>) {
        this.instanceDefinitions = value
    }

    @JvmName("ybeytoqdtnerajsr")
    public suspend fun instanceDefinitions(
        vararg
        values: Output<GameServerGroupInstanceDefinitionArgs>,
    ) {
        this.instanceDefinitions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("lgmiipsnuufygsxy")
    public suspend
    fun instanceDefinitions(values: List<Output<GameServerGroupInstanceDefinitionArgs>>) {
        this.instanceDefinitions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("txulyayakmqukywr")
    public suspend fun launchTemplate(`value`: Output<GameServerGroupLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value The maximum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
     */
    @JvmName("ceyqrcchhdxgyqix")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value The minimum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
     */
    @JvmName("vghbklnimdtmswak")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    @JvmName("fxvecntcwbwxuoyd")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Key-value map of resource tags
     */
    @JvmName("mauurrevoynwixyt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    @JvmName("gwkiuvgfcojhmchw")
    public suspend fun vpcSubnets(`value`: Output<List<String>>) {
        this.vpcSubnets = value
    }

    @JvmName("jcglagyoecvrovqv")
    public suspend fun vpcSubnets(vararg values: Output<String>) {
        this.vpcSubnets = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    @JvmName("rytttjtdsjgejisw")
    public suspend fun vpcSubnets(values: List<Output<String>>) {
        this.vpcSubnets = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iigrkfdtbpoipljr")
    public suspend fun autoScalingPolicy(`value`: GameServerGroupAutoScalingPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingPolicy = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jsbrxaxvceporfvi")
    public suspend
    fun autoScalingPolicy(argument: suspend GameServerGroupAutoScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = GameServerGroupAutoScalingPolicyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoScalingPolicy = mapped
    }

    /**
     * @param value Indicates how GameLift FleetIQ balances the use of Spot Instances and On-Demand Instances.
     * Valid values: `SPOT_ONLY`, `SPOT_PREFERRED`, `ON_DEMAND_ONLY`. Defaults to `SPOT_PREFERRED`.
     */
    @JvmName("eeyrpuisngmfmmmu")
    public suspend fun balancingStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.balancingStrategy = mapped
    }

    /**
     * @param value Name of the game server group.
     * This value is used to generate unique ARN identifiers for the EC2 Auto Scaling group and the GameLift FleetIQ game server group.
     */
    @JvmName("mfvimabiowdsqpgb")
    public suspend fun gameServerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gameServerGroupName = mapped
    }

    /**
     * @param value Indicates whether instances in the game server group are protected from early termination.
     * Unprotected instances that have active game servers running might be terminated during a scale-down event,
     * causing players to be dropped from the game.
     * Protected instances cannot be terminated while there are active game servers running except in the event
     * of a forced game server group deletion.
     * Valid values: `NO_PROTECTION`, `FULL_PROTECTION`. Defaults to `NO_PROTECTION`.
     */
    @JvmName("yhifltqummmlexyb")
    public suspend fun gameServerProtectionPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gameServerProtectionPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("lxlhkepuyhkykssj")
    public suspend fun instanceDefinitions(`value`: List<GameServerGroupInstanceDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceDefinitions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("losrykpwqcerotwj")
    public suspend
    fun instanceDefinitions(argument: List<suspend GameServerGroupInstanceDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GameServerGroupInstanceDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceDefinitions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mqkcghfxkkideiya")
    public suspend fun instanceDefinitions(
        vararg
        argument: suspend GameServerGroupInstanceDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GameServerGroupInstanceDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceDefinitions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nkcgvpawsfconvdh")
    public suspend
    fun instanceDefinitions(argument: suspend GameServerGroupInstanceDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GameServerGroupInstanceDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instanceDefinitions = mapped
    }

    /**
     * @param values
     */
    @JvmName("niqajpnieaemlapu")
    public suspend fun instanceDefinitions(vararg values: GameServerGroupInstanceDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceDefinitions = mapped
    }

    /**
     * @param value
     */
    @JvmName("tgwawdiysddkmqbg")
    public suspend fun launchTemplate(`value`: GameServerGroupLaunchTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jtmxcsiewfdfmuom")
    public suspend
    fun launchTemplate(argument: suspend GameServerGroupLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = GameServerGroupLaunchTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    /**
     * @param value The maximum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale up the group above this maximum.
     */
    @JvmName("jfifmbdbweakecxi")
    public suspend fun maxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value The minimum number of instances allowed in the EC2 Auto Scaling group.
     * During automatic scaling events, GameLift FleetIQ and EC2 do not scale down the group below this minimum.
     */
    @JvmName("cvnpnwscrakpopvh")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value ARN for an IAM role that allows Amazon GameLift to access your EC2 Auto Scaling groups.
     */
    @JvmName("pujhciswbwdbjjfp")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Key-value map of resource tags
     */
    @JvmName("gdsdhcrnbuvjyifw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags
     */
    @JvmName("efqiudoapiowhuee")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    @JvmName("rnavpvbwkhyyntfr")
    public suspend fun vpcSubnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSubnets = mapped
    }

    /**
     * @param values A list of VPC subnets to use with instances in the game server group.
     * By default, all GameLift FleetIQ-supported Availability Zones are used.
     */
    @JvmName("hvkdteldkvbhywdo")
    public suspend fun vpcSubnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSubnets = mapped
    }

    internal fun build(): GameServerGroupArgs = GameServerGroupArgs(
        autoScalingPolicy = autoScalingPolicy,
        balancingStrategy = balancingStrategy,
        gameServerGroupName = gameServerGroupName,
        gameServerProtectionPolicy = gameServerProtectionPolicy,
        instanceDefinitions = instanceDefinitions,
        launchTemplate = launchTemplate,
        maxSize = maxSize,
        minSize = minSize,
        roleArn = roleArn,
        tags = tags,
        vpcSubnets = vpcSubnets,
    )
}
