@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.GameSessionQueueArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.GameSessionQueuePlayerLatencyPolicyArgs
import com.pulumi.aws.gamelift.kotlin.inputs.GameSessionQueuePlayerLatencyPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an GameLift Game Session Queue resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameSessionQueue;
 * import com.pulumi.aws.gamelift.GameSessionQueueArgs;
 * import com.pulumi.aws.gamelift.inputs.GameSessionQueuePlayerLatencyPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GameSessionQueue("test", GameSessionQueueArgs.builder()
 *             .destinations(
 *                 aws_gamelift_fleet.us_west_2_fleet().arn(),
 *                 aws_gamelift_fleet.eu_central_1_fleet().arn())
 *             .notificationTarget(aws_sns_topic.game_session_queue_notifications().arn())
 *             .playerLatencyPolicies(
 *                 GameSessionQueuePlayerLatencyPolicyArgs.builder()
 *                     .maximumIndividualPlayerLatencyMilliseconds(100)
 *                     .policyDurationSeconds(5)
 *                     .build(),
 *                 GameSessionQueuePlayerLatencyPolicyArgs.builder()
 *                     .maximumIndividualPlayerLatencyMilliseconds(200)
 *                     .build())
 *             .timeoutInSeconds(60)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GameLift Game Session Queues using their `name`. For example:
 * ```sh
 *  $ pulumi import aws:gamelift/gameSessionQueue:GameSessionQueue example example
 * ```
 * @property customEventData Information to be added to all events that are related to this game session queue.
 * @property destinations List of fleet/alias ARNs used by session queue for placing game sessions.
 * @property name Name of the session queue.
 * @property notificationTarget An SNS topic ARN that is set up to receive game session placement notifications.
 * @property playerLatencyPolicies One or more policies used to choose fleet based on player latency. See below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeoutInSeconds Maximum time a game session request can remain in the queue.
 */
public data class GameSessionQueueArgs(
    public val customEventData: Output<String>? = null,
    public val destinations: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val notificationTarget: Output<String>? = null,
    public val playerLatencyPolicies: Output<List<GameSessionQueuePlayerLatencyPolicyArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.GameSessionQueueArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.GameSessionQueueArgs =
        com.pulumi.aws.gamelift.GameSessionQueueArgs.builder()
            .customEventData(customEventData?.applyValue({ args0 -> args0 }))
            .destinations(destinations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .notificationTarget(notificationTarget?.applyValue({ args0 -> args0 }))
            .playerLatencyPolicies(
                playerLatencyPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GameSessionQueueArgs].
 */
@PulumiTagMarker
public class GameSessionQueueArgsBuilder internal constructor() {
    private var customEventData: Output<String>? = null

    private var destinations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var notificationTarget: Output<String>? = null

    private var playerLatencyPolicies: Output<List<GameSessionQueuePlayerLatencyPolicyArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeoutInSeconds: Output<Int>? = null

    /**
     * @param value Information to be added to all events that are related to this game session queue.
     */
    @JvmName("xbfjrlosfasdrilr")
    public suspend fun customEventData(`value`: Output<String>) {
        this.customEventData = value
    }

    /**
     * @param value List of fleet/alias ARNs used by session queue for placing game sessions.
     */
    @JvmName("fwswbodvnmywpfvv")
    public suspend fun destinations(`value`: Output<List<String>>) {
        this.destinations = value
    }

    @JvmName("xnqorocraggvsggr")
    public suspend fun destinations(vararg values: Output<String>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values List of fleet/alias ARNs used by session queue for placing game sessions.
     */
    @JvmName("hqefgxkctwysdkdn")
    public suspend fun destinations(values: List<Output<String>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Name of the session queue.
     */
    @JvmName("howdnqxruxxjdxia")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An SNS topic ARN that is set up to receive game session placement notifications.
     */
    @JvmName("lffcrwoqryboxhaq")
    public suspend fun notificationTarget(`value`: Output<String>) {
        this.notificationTarget = value
    }

    /**
     * @param value One or more policies used to choose fleet based on player latency. See below.
     */
    @JvmName("iglbarhxjxlwfqeb")
    public suspend
    fun playerLatencyPolicies(`value`: Output<List<GameSessionQueuePlayerLatencyPolicyArgs>>) {
        this.playerLatencyPolicies = value
    }

    @JvmName("jcgnvqxyikfbaksf")
    public suspend fun playerLatencyPolicies(
        vararg
        values: Output<GameSessionQueuePlayerLatencyPolicyArgs>,
    ) {
        this.playerLatencyPolicies = Output.all(values.asList())
    }

    /**
     * @param values One or more policies used to choose fleet based on player latency. See below.
     */
    @JvmName("rprciaxvakavtlnn")
    public suspend
    fun playerLatencyPolicies(values: List<Output<GameSessionQueuePlayerLatencyPolicyArgs>>) {
        this.playerLatencyPolicies = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bkjcvoohdpxmdthr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Maximum time a game session request can remain in the queue.
     */
    @JvmName("jusrilbajaqpnyeo")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Information to be added to all events that are related to this game session queue.
     */
    @JvmName("qqfwxcwbdfxtpjbv")
    public suspend fun customEventData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEventData = mapped
    }

    /**
     * @param value List of fleet/alias ARNs used by session queue for placing game sessions.
     */
    @JvmName("grvnaososkcvcnta")
    public suspend fun destinations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param values List of fleet/alias ARNs used by session queue for placing game sessions.
     */
    @JvmName("kolwvbmltwsnddbw")
    public suspend fun destinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Name of the session queue.
     */
    @JvmName("dmumuycieiqakxbi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An SNS topic ARN that is set up to receive game session placement notifications.
     */
    @JvmName("tfogecjxfplvfeme")
    public suspend fun notificationTarget(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationTarget = mapped
    }

    /**
     * @param value One or more policies used to choose fleet based on player latency. See below.
     */
    @JvmName("ecsvphplgbljexod")
    public suspend
    fun playerLatencyPolicies(`value`: List<GameSessionQueuePlayerLatencyPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.playerLatencyPolicies = mapped
    }

    /**
     * @param argument One or more policies used to choose fleet based on player latency. See below.
     */
    @JvmName("llwkpcbmlpgmojwb")
    public suspend
    fun playerLatencyPolicies(argument: List<suspend GameSessionQueuePlayerLatencyPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GameSessionQueuePlayerLatencyPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.playerLatencyPolicies = mapped
    }

    /**
     * @param argument One or more policies used to choose fleet based on player latency. See below.
     */
    @JvmName("dktggcfjcxotqyqx")
    public suspend fun playerLatencyPolicies(
        vararg
        argument: suspend GameSessionQueuePlayerLatencyPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GameSessionQueuePlayerLatencyPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.playerLatencyPolicies = mapped
    }

    /**
     * @param argument One or more policies used to choose fleet based on player latency. See below.
     */
    @JvmName("avxyyfgjeqnahcpx")
    public suspend
    fun playerLatencyPolicies(argument: suspend GameSessionQueuePlayerLatencyPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GameSessionQueuePlayerLatencyPolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.playerLatencyPolicies = mapped
    }

    /**
     * @param values One or more policies used to choose fleet based on player latency. See below.
     */
    @JvmName("hejhhdphfodinaiv")
    public suspend fun playerLatencyPolicies(vararg values: GameSessionQueuePlayerLatencyPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.playerLatencyPolicies = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jcrkmxdohnidceii")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qylptgikmncqhcjg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Maximum time a game session request can remain in the queue.
     */
    @JvmName("ecihwmockryaewxc")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    internal fun build(): GameSessionQueueArgs = GameSessionQueueArgs(
        customEventData = customEventData,
        destinations = destinations,
        name = name,
        notificationTarget = notificationTarget,
        playerLatencyPolicies = playerLatencyPolicies,
        tags = tags,
        timeoutInSeconds = timeoutInSeconds,
    )
}
