@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.kotlin.outputs.MatchmakingConfigurationGameProperty
import com.pulumi.aws.gamelift.kotlin.outputs.MatchmakingConfigurationGameProperty.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [MatchmakingConfiguration].
 */
@PulumiTagMarker
public class MatchmakingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MatchmakingConfigurationArgs = MatchmakingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MatchmakingConfigurationArgsBuilder.() -> Unit) {
        val builder = MatchmakingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MatchmakingConfiguration {
        val builtJavaResource =
            com.pulumi.aws.gamelift.MatchmakingConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MatchmakingConfiguration(builtJavaResource)
    }
}

/**
 * Provides a GameLift Alias resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.GameSessionQueue;
 * import com.pulumi.aws.gamelift.GameSessionQueueArgs;
 * import com.pulumi.aws.gamelift.inputs.GameSessionQueuePlayerLatencyPolicyArgs;
 * import com.pulumi.aws.gamelift.MatchmakingRuleSet;
 * import com.pulumi.aws.gamelift.MatchmakingRuleSetArgs;
 * import com.pulumi.aws.gamelift.MatchmakingConfiguration;
 * import com.pulumi.aws.gamelift.MatchmakingConfigurationArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGameSessionQueue = new GameSessionQueue("exampleGameSessionQueue", GameSessionQueueArgs.builder()
 *             .destinations()
 *             .playerLatencyPolicies(
 *                 GameSessionQueuePlayerLatencyPolicyArgs.builder()
 *                     .maximumIndividualPlayerLatencyMilliseconds(3)
 *                     .policyDurationSeconds(7)
 *                     .build(),
 *                 GameSessionQueuePlayerLatencyPolicyArgs.builder()
 *                     .maximumIndividualPlayerLatencyMilliseconds(10)
 *                     .build())
 *             .timeoutInSeconds(25)
 *             .build());
 *         var exampleMatchmakingRuleSet = new MatchmakingRuleSet("exampleMatchmakingRuleSet", MatchmakingRuleSetArgs.builder()
 *             .ruleSetBody(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("name", "test"),
 *                     jsonProperty("ruleLanguageVersion", "1.0"),
 *                     jsonProperty("teams", jsonArray(jsonObject(
 *                         jsonProperty("name", "alpha"),
 *                         jsonProperty("minPlayers", 1),
 *                         jsonProperty("maxPlayers", 5)
 *                     )))
 *                 )))
 *             .build());
 *         var exampleMatchmakingConfiguration = new MatchmakingConfiguration("exampleMatchmakingConfiguration", MatchmakingConfigurationArgs.builder()
 *             .acceptanceRequired(false)
 *             .customEventData("pvp")
 *             .gameSessionData("game_session_data")
 *             .backfillMode("MANUAL")
 *             .requestTimeoutSeconds(30)
 *             .ruleSetName(aws_gamelift_matchmaking_rule_set.test().name())
 *             .gameSessionQueueArns(aws_gamelift_game_session_queue.test().arn())
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * GameLift Matchmaking Configurations can be imported using the ID, e.g.,
 * ```sh
 *  $ pulumi import aws:gamelift/matchmakingConfiguration:MatchmakingConfiguration example <matchmakingconfiguration-id>
 * ```
 *
 */
public class MatchmakingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.gamelift.MatchmakingConfiguration,
) : KotlinCustomResource(javaResource, MatchmakingConfigurationMapper) {
    /**
     * Specifies if the match that was created with this configuration must be accepted by matched players.
     */
    public val acceptanceRequired: Output<Boolean>?
        get() = javaResource.acceptanceRequired().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     */
    public val acceptanceTimeoutSeconds: Output<Int>?
        get() = javaResource.acceptanceTimeoutSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of player slots in a match to keep open for future players.
     */
    public val additionalPlayerCount: Output<Int>?
        get() = javaResource.additionalPlayerCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Matchmaking Configuration ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The method used to backfill game sessions that are created with this matchmaking configuration.
     */
    public val backfillMode: Output<String>?
        get() = javaResource.backfillMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time when the Matchmaking Configuration was created.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Information to be added to all events related to this matchmaking configuration.
     */
    public val customEventData: Output<String>?
        get() = javaResource.customEventData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A human-readable description of the matchmaking configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
     */
    public val flexMatchMode: Output<String>
        get() = javaResource.flexMatchMode().applyValue({ args0 -> args0 })

    /**
     * One or more custom game properties. See below.
     */
    public val gameProperties: Output<List<MatchmakingConfigurationGameProperty>>?
        get() = javaResource.gameProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * A set of custom game session properties.
     */
    public val gameSessionData: Output<String>?
        get() = javaResource.gameSessionData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARNs of the GameLift game session queue resources.
     */
    public val gameSessionQueueArns: Output<List<String>>?
        get() = javaResource.gameSessionQueueArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Name of the matchmaking configuration
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An SNS topic ARN that is set up to receive matchmaking notifications.
     */
    public val notificationTarget: Output<String>?
        get() = javaResource.notificationTarget().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     */
    public val requestTimeoutSeconds: Output<Int>
        get() = javaResource.requestTimeoutSeconds().applyValue({ args0 -> args0 })

    public val ruleSetArn: Output<String>
        get() = javaResource.ruleSetArn().applyValue({ args0 -> args0 })

    /**
     * A rule set names for the matchmaking rule set to use with this configuration.
     */
    public val ruleSetName: Output<String>
        get() = javaResource.ruleSetName().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MatchmakingConfigurationMapper : ResourceMapper<MatchmakingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.gamelift.MatchmakingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): MatchmakingConfiguration =
        MatchmakingConfiguration(javaResource as com.pulumi.aws.gamelift.MatchmakingConfiguration)
}

/**
 * @see [MatchmakingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MatchmakingConfiguration].
 */
public suspend fun matchmakingConfiguration(
    name: String,
    block: suspend MatchmakingConfigurationResourceBuilder.() -> Unit,
): MatchmakingConfiguration {
    val builder = MatchmakingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MatchmakingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun matchmakingConfiguration(name: String): MatchmakingConfiguration {
    val builder = MatchmakingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
