@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [MatchmakingRuleSet].
 */
@PulumiTagMarker
public class MatchmakingRuleSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MatchmakingRuleSetArgs = MatchmakingRuleSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MatchmakingRuleSetArgsBuilder.() -> Unit) {
        val builder = MatchmakingRuleSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MatchmakingRuleSet {
        val builtJavaResource = com.pulumi.aws.gamelift.MatchmakingRuleSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MatchmakingRuleSet(builtJavaResource)
    }
}

/**
 * Provides a GameLift Matchmaking Rule Set resources.
 * ## Import
 * GameLift Matchmaking Rule Sets
 * can be imported using the ID, e.g.,
 * ```sh
 *  $ pulumi import aws:gamelift/matchmakingRuleSet:MatchmakingRuleSet example <ruleset-id>
 * ```
 *
 */
public class MatchmakingRuleSet internal constructor(
    override val javaResource: com.pulumi.aws.gamelift.MatchmakingRuleSet,
) : KotlinCustomResource(javaResource, MatchmakingRuleSetMapper) {
    /**
     * Rule Set ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the matchmaking rule set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * JSON encoded string containing rule set data.
     */
    public val ruleSetBody: Output<String>
        get() = javaResource.ruleSetBody().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MatchmakingRuleSetMapper : ResourceMapper<MatchmakingRuleSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.gamelift.MatchmakingRuleSet::class == javaResource::class

    override fun map(javaResource: Resource): MatchmakingRuleSet = MatchmakingRuleSet(
        javaResource as
            com.pulumi.aws.gamelift.MatchmakingRuleSet,
    )
}

/**
 * @see [MatchmakingRuleSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MatchmakingRuleSet].
 */
public suspend fun matchmakingRuleSet(
    name: String,
    block: suspend MatchmakingRuleSetResourceBuilder.() -> Unit,
): MatchmakingRuleSet {
    val builder = MatchmakingRuleSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MatchmakingRuleSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun matchmakingRuleSet(name: String): MatchmakingRuleSet {
    val builder = MatchmakingRuleSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
