@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.kotlin.outputs.ScriptStorageLocation
import com.pulumi.aws.gamelift.kotlin.outputs.ScriptStorageLocation.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Script].
 */
@PulumiTagMarker
public class ScriptResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScriptArgs = ScriptArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScriptArgsBuilder.() -> Unit) {
        val builder = ScriptArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Script {
        val builtJavaResource = com.pulumi.aws.gamelift.Script(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Script(builtJavaResource)
    }
}

/**
 * Provides an GameLift Script resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Script;
 * import com.pulumi.aws.gamelift.ScriptArgs;
 * import com.pulumi.aws.gamelift.inputs.ScriptStorageLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Script("example", ScriptArgs.builder()
 *             .storageLocation(ScriptStorageLocationArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GameLift Scripts using the ID. For example:
 * ```sh
 *  $ pulumi import aws:gamelift/script:Script example <script-id>
 * ```
 *
 */
public class Script internal constructor(
    override val javaResource: com.pulumi.aws.gamelift.Script,
) : KotlinCustomResource(javaResource, ScriptMapper) {
    /**
     * GameLift Script ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the script
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Information indicating where your game script files are stored. See below.
     */
    public val storageLocation: Output<ScriptStorageLocation>
        get() = javaResource.storageLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Version that is associated with this script.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
     */
    public val zipFile: Output<String>?
        get() = javaResource.zipFile().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ScriptMapper : ResourceMapper<Script> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.gamelift.Script::class == javaResource::class

    override fun map(javaResource: Resource): Script = Script(
        javaResource as
            com.pulumi.aws.gamelift.Script,
    )
}

/**
 * @see [Script].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Script].
 */
public suspend fun script(name: String, block: suspend ScriptResourceBuilder.() -> Unit): Script {
    val builder = ScriptResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Script].
 * @param name The _unique_ name of the resulting resource.
 */
public fun script(name: String): Script {
    val builder = ScriptResourceBuilder()
    builder.name(name)
    return builder.build()
}
