@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin

import com.pulumi.aws.gamelift.ScriptArgs.builder
import com.pulumi.aws.gamelift.kotlin.inputs.ScriptStorageLocationArgs
import com.pulumi.aws.gamelift.kotlin.inputs.ScriptStorageLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an GameLift Script resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.gamelift.Script;
 * import com.pulumi.aws.gamelift.ScriptArgs;
 * import com.pulumi.aws.gamelift.inputs.ScriptStorageLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Script("example", ScriptArgs.builder()
 *             .storageLocation(ScriptStorageLocationArgs.builder()
 *                 .bucket(aws_s3_bucket.example().id())
 *                 .key(aws_s3_object.example().key())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import GameLift Scripts using the ID. For example:
 * ```sh
 *  $ pulumi import aws:gamelift/script:Script example <script-id>
 * ```
 * @property name Name of the script
 * @property storageLocation Information indicating where your game script files are stored. See below.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property version Version that is associated with this script.
 * @property zipFile A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
 */
public data class ScriptArgs(
    public val name: Output<String>? = null,
    public val storageLocation: Output<ScriptStorageLocationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
    public val zipFile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.ScriptArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.ScriptArgs =
        com.pulumi.aws.gamelift.ScriptArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .storageLocation(storageLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 }))
            .zipFile(zipFile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScriptArgs].
 */
@PulumiTagMarker
public class ScriptArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var storageLocation: Output<ScriptStorageLocationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    private var zipFile: Output<String>? = null

    /**
     * @param value Name of the script
     */
    @JvmName("mqaapitnincqoxtx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Information indicating where your game script files are stored. See below.
     */
    @JvmName("qglyohuregsqsoat")
    public suspend fun storageLocation(`value`: Output<ScriptStorageLocationArgs>) {
        this.storageLocation = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("svoolvrxyomstoca")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Version that is associated with this script.
     */
    @JvmName("gpahrdwkfunhtlqx")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
     */
    @JvmName("cgcvguvldunqhubw")
    public suspend fun zipFile(`value`: Output<String>) {
        this.zipFile = value
    }

    /**
     * @param value Name of the script
     */
    @JvmName("cvoohtodaaarhdai")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Information indicating where your game script files are stored. See below.
     */
    @JvmName("garxcdslxfcmdghj")
    public suspend fun storageLocation(`value`: ScriptStorageLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageLocation = mapped
    }

    /**
     * @param argument Information indicating where your game script files are stored. See below.
     */
    @JvmName("vfjbgbbocljutqpm")
    public suspend
    fun storageLocation(argument: suspend ScriptStorageLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ScriptStorageLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageLocation = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iqwurcmwcehwbpud")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("exingoofivariwae")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Version that is associated with this script.
     */
    @JvmName("frxcupvlhlshehyb")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value A data object containing your Realtime scripts and dependencies as a zip  file. The zip file can have one or multiple files. Maximum size of a zip file is 5 MB.
     */
    @JvmName("gyihtmdqtidbwrvo")
    public suspend fun zipFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipFile = mapped
    }

    internal fun build(): ScriptArgs = ScriptArgs(
        name = name,
        storageLocation = storageLocation,
        tags = tags,
        version = version,
        zipFile = zipFile,
    )
}
