@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.BuildStorageLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket Name of your S3 bucket.
 * @property key Name of the zip file containing your build files.
 * @property objectVersion A specific version of the file. If not set, the latest version of the file is retrieved.
 * @property roleArn ARN of the access role that allows Amazon GameLift to access your S3 bucket.
 */
public data class BuildStorageLocationArgs(
    public val bucket: Output<String>,
    public val key: Output<String>,
    public val objectVersion: Output<String>? = null,
    public val roleArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.BuildStorageLocationArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.BuildStorageLocationArgs =
        com.pulumi.aws.gamelift.inputs.BuildStorageLocationArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .objectVersion(objectVersion?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BuildStorageLocationArgs].
 */
@PulumiTagMarker
public class BuildStorageLocationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var key: Output<String>? = null

    private var objectVersion: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value Name of your S3 bucket.
     */
    @JvmName("qtqdiaqvhydemars")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Name of the zip file containing your build files.
     */
    @JvmName("mkvgjyxcocahxahr")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value A specific version of the file. If not set, the latest version of the file is retrieved.
     */
    @JvmName("bramxnuxkdyfhkmm")
    public suspend fun objectVersion(`value`: Output<String>) {
        this.objectVersion = value
    }

    /**
     * @param value ARN of the access role that allows Amazon GameLift to access your S3 bucket.
     */
    @JvmName("fawsjoloyxgmxrei")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Name of your S3 bucket.
     */
    @JvmName("ffufiakrdguallrc")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Name of the zip file containing your build files.
     */
    @JvmName("qecxoenlpvlwekqf")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value A specific version of the file. If not set, the latest version of the file is retrieved.
     */
    @JvmName("qfjuxdmrmyopreqh")
    public suspend fun objectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectVersion = mapped
    }

    /**
     * @param value ARN of the access role that allows Amazon GameLift to access your S3 bucket.
     */
    @JvmName("svkxaidshtquowek")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): BuildStorageLocationArgs = BuildStorageLocationArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        key = key ?: throw PulumiNullFieldException("key"),
        objectVersion = objectVersion,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
