@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.FleetCertificateConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateType Indicates whether a TLS/SSL certificate is generated for a fleet. Valid values are `DISABLED` and `GENERATED`. Default value is `DISABLED`.
 */
public data class FleetCertificateConfigurationArgs(
    public val certificateType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.FleetCertificateConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.FleetCertificateConfigurationArgs =
        com.pulumi.aws.gamelift.inputs.FleetCertificateConfigurationArgs.builder()
            .certificateType(certificateType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetCertificateConfigurationArgs].
 */
@PulumiTagMarker
public class FleetCertificateConfigurationArgsBuilder internal constructor() {
    private var certificateType: Output<String>? = null

    /**
     * @param value Indicates whether a TLS/SSL certificate is generated for a fleet. Valid values are `DISABLED` and `GENERATED`. Default value is `DISABLED`.
     */
    @JvmName("ndgbqbxynjoqasnm")
    public suspend fun certificateType(`value`: Output<String>) {
        this.certificateType = value
    }

    /**
     * @param value Indicates whether a TLS/SSL certificate is generated for a fleet. Valid values are `DISABLED` and `GENERATED`. Default value is `DISABLED`.
     */
    @JvmName("gddmlowlqtojsluw")
    public suspend fun certificateType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateType = mapped
    }

    internal fun build(): FleetCertificateConfigurationArgs = FleetCertificateConfigurationArgs(
        certificateType = certificateType,
    )
}
