@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.FleetEc2InboundPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fromPort Starting value for a range of allowed port numbers.
 * @property ipRange Range of allowed IP addresses expressed in CIDR notationE.g., `000.000.000.000/[subnet mask]` or `0&#46;0&#46;0&#46;0/[subnet mask]`.
 * @property protocol Network communication protocol used by the fleetE.g., `TCP` or `UDP`
 * @property toPort Ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than `from_port`.
 */
public data class FleetEc2InboundPermissionArgs(
    public val fromPort: Output<Int>,
    public val ipRange: Output<String>,
    public val protocol: Output<String>,
    public val toPort: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.FleetEc2InboundPermissionArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.FleetEc2InboundPermissionArgs =
        com.pulumi.aws.gamelift.inputs.FleetEc2InboundPermissionArgs.builder()
            .fromPort(fromPort.applyValue({ args0 -> args0 }))
            .ipRange(ipRange.applyValue({ args0 -> args0 }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .toPort(toPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetEc2InboundPermissionArgs].
 */
@PulumiTagMarker
public class FleetEc2InboundPermissionArgsBuilder internal constructor() {
    private var fromPort: Output<Int>? = null

    private var ipRange: Output<String>? = null

    private var protocol: Output<String>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value Starting value for a range of allowed port numbers.
     */
    @JvmName("uwenlcgdyhbfyecf")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value Range of allowed IP addresses expressed in CIDR notationE.g., `000.000.000.000/[subnet mask]` or `0&#46;0&#46;0&#46;0/[subnet mask]`.
     */
    @JvmName("drdscsiysmkpuikp")
    public suspend fun ipRange(`value`: Output<String>) {
        this.ipRange = value
    }

    /**
     * @param value Network communication protocol used by the fleetE.g., `TCP` or `UDP`
     */
    @JvmName("rtfctdmjccmhonjl")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than `from_port`.
     */
    @JvmName("xlujomccirysugtp")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value Starting value for a range of allowed port numbers.
     */
    @JvmName("oqjufxhwcgjlhvyh")
    public suspend fun fromPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value Range of allowed IP addresses expressed in CIDR notationE.g., `000.000.000.000/[subnet mask]` or `0&#46;0&#46;0&#46;0/[subnet mask]`.
     */
    @JvmName("xlfbrlfsbmadbsbj")
    public suspend fun ipRange(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRange = mapped
    }

    /**
     * @param value Network communication protocol used by the fleetE.g., `TCP` or `UDP`
     */
    @JvmName("hnkhtadtrebteqyf")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than `from_port`.
     */
    @JvmName("dghevtqeujjfeghe")
    public suspend fun toPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): FleetEc2InboundPermissionArgs = FleetEc2InboundPermissionArgs(
        fromPort = fromPort ?: throw PulumiNullFieldException("fromPort"),
        ipRange = ipRange ?: throw PulumiNullFieldException("ipRange"),
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        toPort = toPort ?: throw PulumiNullFieldException("toPort"),
    )
}
