@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.FleetResourceCreationLimitPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property newGameSessionsPerCreator Maximum number of game sessions that an individual can create during the policy period.
 * @property policyPeriodInMinutes Time span used in evaluating the resource creation limit policy.
 */
public data class FleetResourceCreationLimitPolicyArgs(
    public val newGameSessionsPerCreator: Output<Int>? = null,
    public val policyPeriodInMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.FleetResourceCreationLimitPolicyArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.FleetResourceCreationLimitPolicyArgs =
        com.pulumi.aws.gamelift.inputs.FleetResourceCreationLimitPolicyArgs.builder()
            .newGameSessionsPerCreator(newGameSessionsPerCreator?.applyValue({ args0 -> args0 }))
            .policyPeriodInMinutes(policyPeriodInMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetResourceCreationLimitPolicyArgs].
 */
@PulumiTagMarker
public class FleetResourceCreationLimitPolicyArgsBuilder internal constructor() {
    private var newGameSessionsPerCreator: Output<Int>? = null

    private var policyPeriodInMinutes: Output<Int>? = null

    /**
     * @param value Maximum number of game sessions that an individual can create during the policy period.
     */
    @JvmName("ubkmssnvhhulelii")
    public suspend fun newGameSessionsPerCreator(`value`: Output<Int>) {
        this.newGameSessionsPerCreator = value
    }

    /**
     * @param value Time span used in evaluating the resource creation limit policy.
     */
    @JvmName("cboxjenllphndwyo")
    public suspend fun policyPeriodInMinutes(`value`: Output<Int>) {
        this.policyPeriodInMinutes = value
    }

    /**
     * @param value Maximum number of game sessions that an individual can create during the policy period.
     */
    @JvmName("hmdvrtsjaltrqibw")
    public suspend fun newGameSessionsPerCreator(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newGameSessionsPerCreator = mapped
    }

    /**
     * @param value Time span used in evaluating the resource creation limit policy.
     */
    @JvmName("aecrxxfgymxiyrnh")
    public suspend fun policyPeriodInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyPeriodInMinutes = mapped
    }

    internal fun build(): FleetResourceCreationLimitPolicyArgs = FleetResourceCreationLimitPolicyArgs(
        newGameSessionsPerCreator = newGameSessionsPerCreator,
        policyPeriodInMinutes = policyPeriodInMinutes,
    )
}
