@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property gameSessionActivationTimeoutSeconds Maximum amount of time (in seconds) that a game session can remain in status `ACTIVATING`.
 * @property maxConcurrentGameSessionActivations Maximum number of game sessions with status `ACTIVATING` to allow on an instance simultaneously.
 * @property serverProcesses Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
 */
public data class FleetRuntimeConfigurationArgs(
    public val gameSessionActivationTimeoutSeconds: Output<Int>? = null,
    public val maxConcurrentGameSessionActivations: Output<Int>? = null,
    public val serverProcesses: Output<List<FleetRuntimeConfigurationServerProcessArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationArgs =
        com.pulumi.aws.gamelift.inputs.FleetRuntimeConfigurationArgs.builder()
            .gameSessionActivationTimeoutSeconds(
                gameSessionActivationTimeoutSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .maxConcurrentGameSessionActivations(
                maxConcurrentGameSessionActivations?.applyValue({ args0 ->
                    args0
                }),
            )
            .serverProcesses(
                serverProcesses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FleetRuntimeConfigurationArgs].
 */
@PulumiTagMarker
public class FleetRuntimeConfigurationArgsBuilder internal constructor() {
    private var gameSessionActivationTimeoutSeconds: Output<Int>? = null

    private var maxConcurrentGameSessionActivations: Output<Int>? = null

    private var serverProcesses: Output<List<FleetRuntimeConfigurationServerProcessArgs>>? = null

    /**
     * @param value Maximum amount of time (in seconds) that a game session can remain in status `ACTIVATING`.
     */
    @JvmName("uqofhlaioykmdixn")
    public suspend fun gameSessionActivationTimeoutSeconds(`value`: Output<Int>) {
        this.gameSessionActivationTimeoutSeconds = value
    }

    /**
     * @param value Maximum number of game sessions with status `ACTIVATING` to allow on an instance simultaneously.
     */
    @JvmName("iudbautpprrjuupm")
    public suspend fun maxConcurrentGameSessionActivations(`value`: Output<Int>) {
        this.maxConcurrentGameSessionActivations = value
    }

    /**
     * @param value Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
     */
    @JvmName("maaegwwixbrvcnop")
    public suspend
    fun serverProcesses(`value`: Output<List<FleetRuntimeConfigurationServerProcessArgs>>) {
        this.serverProcesses = value
    }

    @JvmName("veiiounfhtlfiuuv")
    public suspend fun serverProcesses(
        vararg
        values: Output<FleetRuntimeConfigurationServerProcessArgs>,
    ) {
        this.serverProcesses = Output.all(values.asList())
    }

    /**
     * @param values Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
     */
    @JvmName("cmjkaguejnwsbrsq")
    public suspend
    fun serverProcesses(values: List<Output<FleetRuntimeConfigurationServerProcessArgs>>) {
        this.serverProcesses = Output.all(values)
    }

    /**
     * @param value Maximum amount of time (in seconds) that a game session can remain in status `ACTIVATING`.
     */
    @JvmName("sfkexpfuniltdyut")
    public suspend fun gameSessionActivationTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gameSessionActivationTimeoutSeconds = mapped
    }

    /**
     * @param value Maximum number of game sessions with status `ACTIVATING` to allow on an instance simultaneously.
     */
    @JvmName("gfxnspkfvhfeidge")
    public suspend fun maxConcurrentGameSessionActivations(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentGameSessionActivations = mapped
    }

    /**
     * @param value Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
     */
    @JvmName("nyjajswytfxdlrsp")
    public suspend fun serverProcesses(`value`: List<FleetRuntimeConfigurationServerProcessArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverProcesses = mapped
    }

    /**
     * @param argument Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
     */
    @JvmName("duberfpvikdeemxl")
    public suspend
    fun serverProcesses(argument: List<suspend FleetRuntimeConfigurationServerProcessArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FleetRuntimeConfigurationServerProcessArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serverProcesses = mapped
    }

    /**
     * @param argument Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
     */
    @JvmName("fthmqkhltofwlieu")
    public suspend fun serverProcesses(
        vararg
        argument: suspend FleetRuntimeConfigurationServerProcessArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FleetRuntimeConfigurationServerProcessArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serverProcesses = mapped
    }

    /**
     * @param argument Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
     */
    @JvmName("uutwfpuakhxiffcj")
    public suspend
    fun serverProcesses(argument: suspend FleetRuntimeConfigurationServerProcessArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FleetRuntimeConfigurationServerProcessArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serverProcesses = mapped
    }

    /**
     * @param values Collection of server process configurations that describe which server processes to run on each instance in a fleet. See below.
     */
    @JvmName("yxlqwattjabqshns")
    public suspend fun serverProcesses(vararg values: FleetRuntimeConfigurationServerProcessArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverProcesses = mapped
    }

    internal fun build(): FleetRuntimeConfigurationArgs = FleetRuntimeConfigurationArgs(
        gameSessionActivationTimeoutSeconds = gameSessionActivationTimeoutSeconds,
        maxConcurrentGameSessionActivations = maxConcurrentGameSessionActivations,
        serverProcesses = serverProcesses,
    )
}
