@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.gamelift.kotlin.inputs

import com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property targetValue Desired value to use with a game server group target-based scaling policy.
 */
public data class GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs(
    public val targetValue: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs =
        com.pulumi.aws.gamelift.inputs.GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs.builder()
            .targetValue(targetValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs].
 */
@PulumiTagMarker
public class GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgsBuilder internal
constructor() {
    private var targetValue: Output<Double>? = null

    /**
     * @param value Desired value to use with a game server group target-based scaling policy.
     */
    @JvmName("fyntigttubscvolq")
    public suspend fun targetValue(`value`: Output<Double>) {
        this.targetValue = value
    }

    /**
     * @param value Desired value to use with a game server group target-based scaling policy.
     */
    @JvmName("vpvmjxpwqqefbsnd")
    public suspend fun targetValue(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetValue = mapped
    }

    internal fun build(): GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs =
        GameServerGroupAutoScalingPolicyTargetTrackingConfigurationArgs(
            targetValue = targetValue ?: throw PulumiNullFieldException("targetValue"),
        )
}
